<?php
// ai/position_sizer.php
// STAGE 4: RISK & MONEY CONTROL
// Calculates precise position size based on Risk, Account Size, and AI Confidence.

function calculate_smart_position($price, $stoploss, $equity, $confidence, $risk_per_trade_percent = 1)
{
    if ($stoploss == 0 || $price == 0)
        return 0;

    // 1. Calculate Risk Per Share
    $risk_per_share = abs($price - $stoploss);
    if ($risk_per_share == 0)
        return 0; // Avoid division by zero

    // 2. Calculate Total Risk Amount
    $risk_amount = $equity * ($risk_per_trade_percent / 100);

    // 3. Raw Quantity
    $raw_qty = $risk_amount / $risk_per_share;

    // 4. Confidence Adjustment (Kelly Criterion-lite)
    // If AI is 90% sure, go full size.
    // If AI is 50% sure, go half size.
    // Normalized Confidence: (Conf - 50) * 2 / 100?
    // Let's use simple linear scaling:
    $scaler = max(0.1, min(1.0, $confidence / 80));

    $adjusted_qty = floor($raw_qty * $scaler);

    return [
        "qty" => $adjusted_qty,
        "risk_amt" => $risk_amount, // Max risk if stopped out
        "scaler" => round($scaler, 2)
    ];
}
?>