<?php
// ai/session_detector.php
// STAGE 3: SESSION AWARENESS
// Adjusts trading aggression based on Global Market Sessions.

function get_current_session_bias()
{
    // Current Time (Server Time - assumed aligned or set to IST)
    // Indian Market: 9:15 - 15:30 IST
    // US Market: 19:00 - 01:30 IST
    // Asian Market: 05:30 - 11:30 IST

    $h = (int) date('H');
    $m = (int) date('i');
    $time_val = $h + ($m / 60);

    $session = "ASIA";
    $vol_bias = "LOW"; // Default low vol
    $desc = "Asian Session (05:30 - 11:30)";

    // crude approximation for IST timezone
    if ($time_val >= 9.25 && $time_val < 15.5) {
        $session = "INDIA";
        $vol_bias = "HIGH"; // Our primary market
        $desc = "Indian Session (Active)";
    } elseif ($time_val >= 13.5 && $time_val < 19.0) {
        $session = "EUROPE";
        $vol_bias = "MEDIUM";
        $desc = "London Session (Overlap)";
    } elseif ($time_val >= 19.0 || $time_val < 1.5) {
        $session = "US";
        $vol_bias = "HIGH";
        $desc = "New York Session";
    }

    return [
        "session" => $session,
        "vol_bias" => $vol_bias,
        "desc" => $desc
    ];
}
?>