<?php
// ai/session_manager.php
// LEVEL 9: SESSION & TIME ZONE AWARENESS

function get_current_session()
{
    // UTC Times
    // Asian: 00:00 - 09:00 UTC
    // London: 07:00 - 16:00 UTC
    // NY: 12:00 - 21:00 UTC

    $h = (int) date('G'); // 0-23 UTC based on server? 
    // Assuming Server is UTC or we adjust. Let's assume server is local/IST or UTC. 
    // Best is to use specific ranges.

    // Use simple logic for now
    if ($h >= 1 && $h < 11)
        return "ASIA";
    if ($h >= 12 && $h < 17)
        return "EUROPE_US_OVERLAP"; // Volatile
    if ($h >= 17 && $h < 22)
        return "US";

    return "LOW_VOL";
}

function get_session_weight($strategy)
{
    $sess = get_current_session();

    // ASIA: Range strategies good, Breakout bad
    if ($sess === "ASIA") {
        if ($strategy === 'breakout')
            return 0.5; // Penalty
        if ($strategy === 'reversal')
            return 1.2; // Boost
    }

    // OVERLAP: Trend strategies high
    if ($sess === "EUROPE_US_OVERLAP") {
        if ($strategy === 'trend')
            return 1.3;
        if ($strategy === 'scalp')
            return 1.0;
    }

    return 1.0;
}
?>