<?php
// core/cache_engine.php
// Robust File-Based Caching System for High Performance

function get_cache_dir()
{
    $dir = __DIR__ . '/../cache';
    if (!is_dir($dir)) {
        mkdir($dir, 0777, true);
    }
    return $dir;
}

function cache_get($key)
{
    $file = get_cache_dir() . '/' . md5($key) . '.cache';
    if (!file_exists($file))
        return null;

    $content = file_get_contents($file);
    if (!$content)
        return null;

    $data = json_decode($content, true);
    if (!$data || !isset($data['expiry']) || !isset($data['payload']))
        return null;

    // Check Expiry
    if (time() > $data['expiry']) {
        @unlink($file); // Delete expired
        return null;
    }

    return $data['payload'];
}

function cache_set($key, $payload, $ttl_seconds = 60)
{
    $file = get_cache_dir() . '/' . md5($key) . '.cache';
    $data = [
        'expiry' => time() + $ttl_seconds,
        'payload' => $payload
    ];
    // Use atomic write if possible, or standard
    file_put_contents($file, json_encode($data));
}

function cache_clear($key)
{
    $file = get_cache_dir() . '/' . md5($key) . '.cache';
    if (file_exists($file))
        @unlink($file);
}
?>