<?php
// debug/debug_us_ticker.php
// Standalone debugger for US Scan issues

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "Starting US Ticker Debug...\n";

// 1. Mock Context
define('__ROOT__', dirname(__DIR__));
require_once __ROOT__ . '/trade_engine.php';

// 2. Test Fetch for AAPL
echo "Fetching Data for AAPL (US)...\n";
$res = fetch_yahoo_data('AAPL', '1d');

if ($res['success']) {
    echo "✅ Fetch SUCCESS\n";
    echo "Price: " . $res['price'] . "\n";
    echo "Candles: " . count($res['candles']) . "\n";
} else {
    echo "❌ Fetch FAILED\n";
    print_r($res);
    exit;
}

// 3. Test Full Analysis
echo "\nRunning Full Analysis...\n";
$analysis = run_analysis('AAPL', '1d');

if ($analysis && isset($analysis['analysis'])) {
    echo "✅ Analysis SUCCESS\n";
    print_r($analysis['analysis']['intraday']['signal']);
} else {
    echo "❌ Analysis FAILED\n";
    print_r($analysis);
}
?>