<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Frontend API Inspector</title>
    <style>
        body {
            background: #111;
            color: #fff;
            font-family: monospace;
            padding: 20px;
        }
    </style>
</head>

<body>
    <h2>🕵️ Frontend API Inspector</h2>
    <p>Testing connection from <b>Browser</b> to <b>API</b>...</p>

    <div id="status">Testing...</div>
    <hr>
    <h3>Raw Response:</h3>
    <pre id="output" style="background:#222;padding:10px;border:1px solid #444;white-space:pre-wrap;"></pre>

    <script>
        async function test() {
            const out = document.getElementById('output');
            const st = document.getElementById('status');

            try {
                // Fetch exactly what app.js fetches
                const url = 'api/trade.php?action=get_data&symbol=RELIANCE.NS&interval=5m';
                out.innerText += `Fetching: ${url}\n\n`;

                const res = await fetch(url);
                const text = await res.text();

                out.innerText += text;

                try {
                    const json = JSON.parse(text);
                    if (json.success) {
                        st.innerHTML = "<span style='color:#4caf50'>✅ VALID JSON & SUCCESS</span>";
                    } else {
                        st.innerHTML = "<span style='color:#ff9800'>⚠️ VALID JSON BUT SUCCES=FALSE</span>";
                    }
                } catch (e) {
                    st.innerHTML = "<span style='color:#f44336'>❌ INVALID JSON (Whitespace or PHPErrors detected)</span>";
                }

            } catch (e) {
                st.innerHTML = "<span style='color:red'>❌ NETWORK ERROR: " + e.message + "</span>";
            }
        }
        test();
    </script>
</body>

</html>