<?php
require_once '../core/session.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 1. LOGIN CHECK
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

// 2. PREMIUM CHECK (Security Requirement)
if (($_SESSION['plan'] ?? 'free') === 'free' && ($_SESSION['role'] ?? 'user') !== 'admin') {
    die("
    <div style='background:#111; color:#fff; font-family:sans-serif; height:100vh; display:flex; flex-direction:column; justify-content:center; align-items:center;'>
        <h1 style='color:#eebb00;'>🔒 Premium Feature</h1>
        <p>Paper Trading is available only for Premium Users.</p>
        <a href='../index.php' style='color:#3d5afe; text-decoration:none; border:1px solid #3d5afe; padding:10px 20px; border-radius:4px;'>Go Back</a>
    </div>
    ");
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Paper Trading | AutoTrade AI</title>
    <link rel="stylesheet" href="style.css?v=<?php echo time(); ?>">
    <!-- Hybrid Theme: Dark App, White Chart -->
</head>

<body>
    <div class="paper-grid">
        <!-- HEADER -->
        <div class="header">
            <div class="logo">AutoTrade Paper <span style="font-size:0.8em; color:#666;">v2.5 (AI Linked)</span></div>
            <div class="balance-box">
                <a href="../index.php"
                    style="background:#222; color:#ccc; text-decoration:none; padding:4px 10px; font-size:0.7rem; border-radius:3px; border:1px solid #444; margin-right:10px;">Back
                    to App</a>
                Wallet: <span id="walletBalance" style="color:#eebb00; font-weight:bold;">₹100,00,00,000</span>
                <button onclick="resetAccount()" class="btn-reset"
                    style="width: auto; padding: 4px 12px; font-size: 0.7rem; margin-left: 10px;">Reset</button>
            </div>
        </div>

        <!-- SIDEBAR: MARKET WATCH -->
        <div class="panel sidebar">
            <div class="market-switch">
                <button id="btnIN" class="active" onclick="switchMarket('IN')">NIFTY 50</button>
                <button id="btnUS" onclick="switchMarket('US')">US TECH</button>
            </div>
            <input type="text" id="sidebarSearch" placeholder="Search..." onkeyup="filterStocks()">

            <div id="stockList" class="stock-list">
                <!-- JS Populates -->
            </div>
        </div>

        <!-- LEFT: AI SIGNALS (FULL INTERFACE) -->
        <div class="panel signal-panel">
            <h3
                style="margin-top:0; color:#eee; font-size:13px; border-bottom:1px solid #2a2e39; padding-bottom:8px; margin-bottom:10px;">
                AI PREDICTION ENGINE</h3>

            <!-- TIME HORIZON TABS -->
            <div class="ai-tabs">
                <button class="ai-tab active" onclick="switchAI('intraday', this)">INTRADAY</button>
                <button class="ai-tab" onclick="switchAI('swing', this)">SWING</button>
                <button class="ai-tab" onclick="switchAI('longterm', this)">LONG</button>
            </div>

            <!-- AI CONTENT: INTRADAY -->
            <div id="ai-content-intraday" class="ai-content active">
                <div class="signal-row">
                    <span class="signal-label">SIGNAL</span>
                    <span class="signal-val" id="ai-signal-intraday">WAIT</span>
                </div>
                <div class="signal-row">
                    <span class="signal-label">CONFIDENCE</span>
                    <div class="confidence-bar-bg">
                        <div class="confidence-bar-fill" id="ai-conf-intraday" style="width: 0%"></div>
                    </div>
                    <span id="ai-conf-val-intraday" style="color:#fff; font-size:0.7rem;">0%</span>
                </div>
                <div class="malayalam-text" id="ai-desc-intraday">
                    Scanning market data...
                </div>
            </div>

            <!-- AI CONTENT: SWING -->
            <div id="ai-content-swing" class="ai-content">
                <div class="signal-row">
                    <span class="signal-label">TREND</span>
                    <span class="signal-val" id="ai-signal-swing">NEUTRAL</span>
                </div>
                <div class="signal-row">
                    <span class="signal-label">STRENGTH</span>
                    <div class="confidence-bar-bg">
                        <div class="confidence-bar-fill" id="ai-conf-swing" style="width: 0%"></div>
                    </div>
                    <span id="ai-conf-val-swing" style="color:#fff; font-size:0.7rem;">0%</span>
                </div>
                <div class="malayalam-text" id="ai-desc-swing">
                    Checking daily trend...
                </div>
            </div>

            <!-- AI CONTENT: LONGTERM -->
            <div id="ai-content-longterm" class="ai-content">
                <div class="signal-row">
                    <span class="signal-label">OUTLOOK</span>
                    <span class="signal-val" id="ai-signal-longterm">HOLD</span>
                </div>
                <div class="signal-row">
                    <span class="signal-label">QUALITY</span>
                    <div class="confidence-bar-bg">
                        <div class="confidence-bar-fill" id="ai-conf-longterm" style="width: 0%"></div>
                    </div>
                    <span id="ai-conf-val-longterm" style="color:#fff; font-size:0.7rem;">0%</span>
                </div>
                <div class="malayalam-text" id="ai-desc-longterm">
                    Reviewing fundamentals...
                </div>
            </div>

            <!-- SENTIMENT METER -->
            <div class="sentiment-box">
                <div style="font-size:0.7rem; margin-bottom:5px; color:#7e879a;">NEWS SENTIMENT</div>
                <div class="sentiment-meter">
                    <div class="meter-needle" id="sentiment-needle" style="left: 50%;"></div>
                </div>
            </div>

            <!-- OLD FEED LIST (Hidden or minimized, kept for history if needed, but user wants Exact AI) -->
            <div style="margin-top:20px; border-top:1px solid #2a2e39; padding-top:10px;">
                <div style="font-size:0.7rem; color:#666; margin-bottom:5px;">RECENT SIGNALS</div>
                <div id="aiFeedList" style="max-height:100px; overflow-y:auto;">
                    <!-- Condensed Feed -->
                </div>
            </div>

        </div>

        <!-- CENTER: CHART (WHITE THEME) -->
        <div class="panel chart-panel">
            <div style="position: absolute; top: 10px; left: 10px; z-index: 10; display: flex; gap: 10px;">
                <!-- Updated IDs for logic.js -->
                <h2 id="chartSymbolDisplay" style="margin:0; font-size:24px;">RELIANCE.NS</h2>
                <h2 id="chartPriceDisplay" style="margin:0; color:#2962ff; font-size:24px;">--</h2>
            </div>

            <!-- CANVAS WRAPPER (Fixes Ticker Layout) -->
            <div style="flex: 1; width: 100%; position: relative; overflow: hidden;">
                <canvas id="paperChart" style="width:100%; height:100%; display:block;"></canvas>
            </div>

            <!-- Hidden Input for compatibility -->
            <input type="hidden" id="symbolInput" value="RELIANCE.NS">

            <!-- INCORPORATED TICKERS -->
            <div class="ticker-stack">
                <!-- 1. INTRADAY -->
                <div class="ticker-wrap-inline" id="ticker-intraday">
                    <div class="ticker-heading" style="color:#0ecb81; min-width:80px;">INTRADAY</div>
                    <div class="ticker-move">
                        <div class="ticker-item">Scanning...</div>
                    </div>
                </div>
                <!-- 2. SWING -->
                <div class="ticker-wrap-inline" id="ticker-swing">
                    <div class="ticker-heading" style="color:#3b82f6; min-width:80px;">SWING</div>
                    <div class="ticker-move">
                        <div class="ticker-item">Scanning...</div>
                    </div>
                </div>
                <!-- 3. LONG TERM -->
                <div class="ticker-wrap-inline" id="ticker-longterm">
                    <div class="ticker-heading" style="color:#eebb00; min-width:80px;">INVEST</div>
                    <div class="ticker-move">
                        <div class="ticker-item">Scanning...</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- RIGHT: ORDER PANEL -->
        <div class="panel order-panel">
            <h3 style="margin-top:0; color:#eee; font-size:14px; border-bottom:1px solid #2a2e39; padding-bottom:8px;">
                Place Order</h3>

            <label style="font-size:0.8rem; color:#888;">AI Confidence</label>
            <div id="aiConfidence"
                style="background:#2a2e39; padding:8px; margin-bottom:15px; color:#aaa; font-weight:bold; border-radius:4px;">
                --%</div>

            <label style="font-size:0.8rem; color:#888;">Type</label>
            <div style="display:flex; gap:5px; margin-bottom:15px;">
                <button class="buy" onclick="setOrderType('BUY')" id="btnBuySide">BUY</button>
                <button class="sell" onclick="setOrderType('SELL')" id="btnSellSide" style="opacity:0.3;">SELL</button>
            </div>

            <label style="font-size:0.8rem; color:#888;">Quantity</label>
            <input type="number" id="orderQty" value="1">

            <label style="font-size:0.8rem; color:#888;">Stop Loss</label>
            <input type="number" id="orderSL" placeholder="Price">

            <label style="font-size:0.8rem; color:#888;">Target</label>
            <input type="number" id="orderTgt" placeholder="Price">

            <button onclick="placeOrder()" id="btnExecute"
                style="background:#2962ff; border:none; color:white; font-weight:bold; margin-top:20px; padding:12px;">EXECUTE
                TRADE</button>

            <div id="orderStatus" style="font-size:0.8rem; margin-top:10px; text-align:center;"></div>
        </div>

        <!-- BOTTOM: PORTFOLIO -->
        <div class="panel portfolio-panel">
            <h3 style="margin-top:0; color:#eee; font-size:14px; display:inline-block; margin-right:20px;">Open
                Positions</h3>
            <table id="positionsTable">
                <thead>
                    <tr>
                        <th>Symbol</th>
                        <th>Side</th>
                        <th>Qty</th>
                        <th>Entry</th>
                        <th>LTP</th>
                        <th>P&L</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- JS Populates -->
                </tbody>
            </table>
        </div>
    </div>

    <script>
        // GLOBAL API TOKEN (Injected from Server)
        const API_TOKEN = "<?php echo API_TOKEN; ?>";
        const USER_ID = <?php echo $_SESSION['user_id']; ?>;
    </script>
    <script src="../stocks.js?v=V37"></script>
    <script src="logic.js?v=V37_Global"></script>
</body>

</html>