<?php
// server_diag.php
// AutoTrade AI Server Diagnosis Tool
header('Content-Type: text/plain');

echo "AutoTrade AI Server Diagnostics\n";
echo "===============================\n\n";

// 1. PHP Version
echo "[1] Checking PHP Version...\n";
echo "PHP Version: " . phpversion() . "\n";
if (version_compare(phpversion(), '7.4.0', '<')) {
    echo "WARNING: PHP 7.4 or higher recommended.\n";
} else {
    echo "OK.\n";
}
echo "\n";

// 2. cURL
echo "[2] Checking cURL Extension...\n";
if (function_exists('curl_init')) {
    echo "OK: cURL is enabled.\n";
    // Quick Connectivity Test
    $ch = curl_init('https://www.google.com');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    $res = curl_exec($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    echo "Connectivity Test (Google): HTTP $http\n";
} else {
    echo "CRITICAL FAULT: cURL is NOT enabled. Trading data cannot be fetched.\n";
}
echo "\n";

// 3. File Permissions
echo "[3] Checking File Permissions...\n";
$files = ['store.json', 'users.json', 'trade_history.json', 'logs'];
foreach ($files as $f) {
    $path = __DIR__ . '/' . $f;
    if (!file_exists($path)) {
        if ($f === 'logs') {
            mkdir($path);
            echo "$f: Created (OK).\n";
        } else {
            echo "$f: Missing (Warning).\n";
        }
    } else {
        if (is_writable($path)) {
            echo "$f: Writable (OK).\n";
        } else {
            echo "$f: NOT Writable (Error).\n";
        }
    }
}
echo "\n";

// 4. API Test
echo "[4] Testing API Response (Internal)...\n";
// Improve robustness: invoke main function if possible or just check files
if (file_exists(__DIR__ . '/api/trade.php')) {
    echo "api/trade.php: Found.\n";

    // Simulate API Call? Difficult without HTTP stack.
    // We will check Syntax Error instead.
    echo "Checking for Syntax Errors in api/trade.php...\n";
    $output = shell_exec('php -l api/trade.php');
    echo "Lint Output: " . ($output ?: 'Not available (shell_exec disabled)') . "\n";
} else {
    echo "api/trade.php: MISSING (Critical).\n";
}

echo "\n-------------------------------\n";
echo "Diagnostics Complete.\n";
?>