<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Signup - AutoTrade AI</title>
    <style>
        body {
            background-color: #0b0e11;
            color: #d1d4dc;
            font-family: 'Inter', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }

        .login-card {
            background: #1b2029;
            padding: 40px;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.5);
            width: 100%;
            max-width: 400px;
            border: 1px solid #2b313f;
            text-align: center;
        }

        .logo {
            font-size: 1.5rem;
            font-weight: 800;
            color: #fff;
            margin-bottom: 30px;
            letter-spacing: 1px;
        }

        .logo span {
            color: #0ecb81;
        }

        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }

        label {
            display: block;
            margin-bottom: 8px;
            color: #888;
            font-size: 0.9rem;
        }

        input {
            width: 100%;
            padding: 12px;
            background: #0b0e11;
            border: 1px solid #2b313f;
            border-radius: 4px;
            color: #fff;
            font-size: 1rem;
            box-sizing: border-box;
            transition: border-color 0.2s;
        }

        input:focus {
            border-color: #0ecb81;
            outline: none;
        }

        .btn-register {
            background: #0ecb81;
            color: #fff;
            border: none;
            width: 100%;
            padding: 12px;
            border-radius: 4px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s;
        }

        .btn-register:hover {
            background: #0aa869;
        }

        .error-msg {
            color: #f6465d;
            font-size: 0.9rem;
            margin-top: 15px;
            display: none;
        }

        .login-link {
            margin-top: 20px;
            font-size: 0.9rem;
            color: #888;
        }

        .login-link a {
            color: #3b82f6;
            text-decoration: none;
            font-weight: 600;
        }
    </style>
</head>

<body>

    <div class="login-card">
        <div class="logo">AUTO<span>TRADE</span>.AI</div>
        <form id="signupForm">
            <div class="form-group">
                <label>Username</label>
                <input type="text" id="username" name="username" required placeholder="Choose a username">
            </div>
            <div class="form-group">
                <label>Password</label>
                <input type="password" id="password" name="password" required placeholder="Create password">
            </div>
            <div class="form-group">
                <label>Confirm Password</label>
                <input type="password" id="confirm_password" name="confirm_password" required
                    placeholder="Confirm password">
            </div>
            <button type="submit" class="btn-register" id="btnSignup">Create Account</button>
            <div class="error-msg" id="errorMsg">Registration Failed</div>
        </form>
        <div class="login-link">
            Already have an account? <a href="login.php">Login here</a>
        </div>
    </div>

    <script>
        document.getElementById('signupForm').addEventListener('submit', async function (e) {
            e.preventDefault();
            const btn = document.getElementById('btnSignup');
            const err = document.getElementById('errorMsg');
            const p1 = document.getElementById('password').value;
            const p2 = document.getElementById('confirm_password').value;

            if (p1 !== p2) {
                err.innerText = "Passwords do not match";
                err.style.display = 'block';
                return;
            }

            btn.disabled = true;
            btn.innerText = "Creating Account...";
            err.style.display = 'none';

            const formData = new FormData(this);

            try {
                const res = await fetch('api.php?action=signup', {
                    method: 'POST',
                    body: formData
                });
                const data = await res.json();

                if (data.status === 'success') {
                    alert('Account Created! Please Login.');
                    window.location.href = 'login.php';
                } else {
                    err.innerText = data.error || "Registration Failed";
                    err.style.display = 'block';
                    btn.disabled = false;
                    btn.innerText = "Create Account";
                }
            } catch (e) {
                console.error(e);
                err.innerText = "Connection Error";
                err.style.display = 'block';
                btn.disabled = false;
                btn.innerText = "Create Account";
            }
        });
    </script>
</body>

</html>