<?php
// backtest/simple_backtest.php
// STAGE 8: VALIDATION
// Runs the AI Brain on historical data to check Win Rate.

require_once __DIR__ . '/../trade_engine.php';
require_once __DIR__ . '/../api.php'; // For fetch_yahoo_finance

function run_backtest($symbol, $candles)
{
    echo "Running Backtest for $symbol on " . count($candles) . " candles...\n";

    $wins = 0;
    $losses = 0;
    $total_trades = 0;
    $log = [];

    // Need at least 50 candles to start AIf
    $min_data = 50;

    for ($i = $min_data; $i < count($candles) - 1; $i++) {
        // Slice data for this point in time
        $history = array_slice($candles, 0, $i + 1);
        $current_candle = $candles[$i];
        $price = $current_candle['c'];

        // Mock State (In real backtest, we'd recalc sentiment, but we use neutral here)
        $ai_result = predict_intraday_hyper($history, $price, 0, 'UNKNOWN', $symbol);

        $signal = $ai_result['signal'];
        $sl = $ai_result['details']['support'] ?? 0; // SL
        $tp = $ai_result['details']['resistance'] ?? 0; // TP

        if ($signal === 'BUY' && $sl > 0 && $tp > 0) {
            // Forward Test
            $outcome = 'OPEN';
            for ($j = $i + 1; $j < count($candles); $j++) {
                $future = $candles[$j];
                if ($future['l'] <= $sl) {
                    $outcome = 'LOSS';
                    $losses++;
                    break;
                }
                if ($future['h'] >= $tp) {
                    $outcome = 'WIN';
                    $wins++;
                    break;
                }
            }
            if ($outcome !== 'OPEN') {
                $total_trades++;
                $log[] = "Trade #$total_trades: $signal @ $price -> $outcome (SL: $sl, TP: $tp)";
            }
        }
        // Add SELL logic similarly...
    }

    $win_rate = ($total_trades > 0) ? round(($wins / $total_trades) * 100, 2) : 0;

    return [
        "total" => $total_trades,
        "wins" => $wins,
        "losses" => $losses,
        "win_rate" => $win_rate,
        "log" => $log
    ];
}

// CLI Runner
if (php_sapi_name() == "cli") {
    // Mock run if called from CLI
    // Ideally user uploads candles or we fetch
}
?>