<?php
// connection_test.php
// Run this to see EXACTLY why data is not loading.

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<head><title>Connection Test</title><style>body{background:#111; color:#ddd; font-family:monospace; padding:20px;}</style></head>";
echo "<h2>🛑 AutoTrade Connection Tester</h2>";

$symbol = "RELIANCE.NS";
$url = "https://query1.finance.yahoo.com/v8/finance/chart/" . urlencode($symbol) . "?interval=1m&range=1d";

echo "<b>Target:</b> <a href='$url' target='_blank' style='color:#4caf50'>$url</a><br><hr>";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 20);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_ENCODING, ''); // Important for GZIP
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36");
// Debug: Measure time
$start = microtime(true);
$response = curl_exec($ch);
$duration = round(microtime(true) - $start, 2);

$error = curl_error($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$content_type = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
curl_close($ch);

echo "<b>Time Taken:</b> {$duration}s<br>";
echo "<b>HTTP Code:</b> ";
if ($http_code == 200)
    echo "<span style='color:#4caf50'>200 OK</span>";
else
    echo "<span style='color:#f44336'>$http_code (Error)</span>";
echo "<br>";

if ($error) {
    echo "<h3 style='color:#f44336'>❌ CURL ERROR:</h3>";
    echo "<pre>$error</pre>";
    exit;
}

if ($http_code != 200) {
    echo "<h3 style='color:#f44336'>❌ RESPONSE ERROR:</h3>";
    echo "<p>Yahoo blocked the request or returned an error.</p>";
    echo "<textarea style='width:100%; height:200px; background:#222; color:#f88;'>$response</textarea>";
    exit;
}

$json = json_decode($response, true);
if (!$json) {
    echo "<h3 style='color:#ffeb3b'>⚠️ INVALID JSON (Decode Failed):</h3>";
    echo "<p>The response was not valid JSON. Possibly HTML or empty.</p>";
    echo "<textarea style='width:100%; height:200px; background:#222; color:#fff;'>$response</textarea>";
} else {
    // Check internal Yahoo error
    if (isset($json['chart']['error']) && $json['chart']['error']) {
        echo "<h3 style='color:#f44336'>❌ YAHOO API ERROR:</h3>";
        print_r($json['chart']['error']);
    } elseif (isset($json['chart']['result'][0]['meta'])) {
        echo "<h3 style='color:#4caf50'>✅ SUCCESS! Data Connection is Perfect.</h3>";
        $meta = $json['chart']['result'][0]['meta'];
        $count = count($json['chart']['result'][0]['timestamp'] ?? []);
        echo "Symbol: <b>" . $meta['symbol'] . "</b><br>";
        echo "Price: <b>" . $meta['regularMarketPrice'] . "</b><br>";
        echo "Candles: <b>" . $count . "</b><br>";
        echo "<hr><i>Great! Your hosting provider allows connections to Yahoo Finance. The App should work perfectly.</i>";
    } else {
        echo "<h3 style='color:#ffeb3b'>⚠️ UNEXPECTED JSON STRUCTURE:</h3>";
        print_r($json);
    }
}

echo "<h2>📂 Permission Check</h2>";
$logDir = __DIR__ . '/logs';
if (!is_dir($logDir)) {
    echo "Creating logs directory... ";
    if (@mkdir($logDir, 0755, true))
        echo "<span style='color:green'>Created</span><br>";
    else
        echo "<span style='color:red'>Failed (Create 'logs' folder manually)</span><br>";
}

if (is_writable($logDir)) {
    echo "Logs Directory: <span style='color:green'>Writable (OK)</span>";
} else {
    echo "Logs Directory: <span style='color:red'>Not Writable</span><br>";
    echo "<i>Fix: In cPanel File Manager, set 'logs' folder permission to 755 or 777.</i>";
}
?>