<?php
// core/admin_guard.php
// PILLAR 1: SECURITY (ADMIN SESSION)

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in AND is admin
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] ?? '') !== 'admin') {
    http_response_code(401); // Unauthorized

    // Check if it's an API request or Page request
    if (strpos($_SERVER['REQUEST_URI'], '.php') !== false && !strpos($_SERVER['REQUEST_URI'], 'api.php')) {
        // Redirect Pages to Login
        header("Location: login.php");
    } else {
        // Return JSON for API
        header('Content-Type: application/json');
        echo json_encode(['error' => 'Admin Access Required']);
    }
    exit();
}
?>