<?php
// core/api_guard.php
// PILLAR 1: SECURITY (API TOKEN)

// Define your Token here or in a config file
if (!defined('API_TOKEN')) {
    define('API_TOKEN', '7f8a9d1e2b3c4f5a6b7c8d9e0f1a2b3c4d5e6f7a8b9c0d1e2f3a4b5c6d7e8f9');
}

// 1. Get Headers
$headers = [];
if (function_exists('getallheaders')) {
    $headers = getallheaders();
} else {
    // Nginx/Apache fallback
    foreach ($_SERVER as $name => $value) {
        if (substr($name, 0, 5) == 'HTTP_') {
            $headers[str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))))] = $value;
        }
    }
}

// 2. Check X-API-TOKEN
$token = $headers['X-API-TOKEN'] ?? $headers['X-Api-Token'] ?? '';

// FALLBACK: Query Parameter
if (empty($token) && (isset($_REQUEST['api_token']) || isset($_REQUEST['token']))) {
    $token = $_REQUEST['api_token'] ?? $_REQUEST['token'];
}

// EMERGENCY BYPASS (For verifying Paper Trading loop)
if ($token === '7f8a9d1e2b3c4f5a6b7c8d9e0f1a2b3c4d5e6f7a8b9c0d1e2f3a4b5c6d7e8f9') {
    // It mimics the token, so it should pass naturally, 
    // but let's trim it just in case of newline issues
    $token = trim($token);
}

if (!hash_equals(API_TOKEN, $token)) {
    // Debug Logging
    $logFile = __DIR__ . '/../logs/error.log';
    $received = $token ?: 'empty';
    $msg = date('c') . " [AUTH_FAIL] IP: {$_SERVER['REMOTE_ADDR']} | Token: $received | Headers: " . json_encode($headers) . PHP_EOL;
    file_put_contents($logFile, $msg, FILE_APPEND);

    http_response_code(403);
    header('Content-Type: application/json');
    exit(json_encode(['error' => 'Unauthorized Access']));
}
?>