<?php
// core/error_handler.php
// PILLAR 4: ERROR LOGGING

ini_set('display_errors', 0);
ini_set('log_errors', 1);

// Ensure logs directory exists
$logDir = __DIR__ . '/../logs';
if (!is_dir($logDir)) {
    mkdir($logDir, 0755, true);
}

$logFile = $logDir . '/error.log';
ini_set('error_log', $logFile);

set_exception_handler(function ($e) use ($logFile) {
    $msg = date('c') . ' [EXCEPTION] ' . $e->getMessage() . ' in ' . $e->getFile() . ':' . $e->getLine() . PHP_EOL;
    file_put_contents($logFile, $msg, FILE_APPEND);
    // Silent fail for user, critical log for admin
});

set_error_handler(function ($errno, $errstr, $errfile, $errline) use ($logFile) {
    if (!(error_reporting() & $errno))
        return;
    $msg = date('c') . ' [ERROR] ' . $errstr . ' in ' . $errfile . ':' . $errline . PHP_EOL;
    file_put_contents($logFile, $msg, FILE_APPEND);
});
?>