<?php
// core/fetch_engine.php
// Handles HTTP Requests with "Human-Like" Headers to bypass Rate Limits.
// V2.0 - Cookie Support + Logging

function fetch_url_secure($url)
{
    $log_file = __DIR__ . '/../logs/fetch_error.log';
    if (!file_exists(dirname($log_file)))
        mkdir(dirname($log_file), 0777, true);

    // 1. TRY cURL
    if (function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_ENCODING, ""); // Enable GZIP compression (Critical for Yahoo)
        curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4); // Force IPv4 to avoid IPv6 timeouts
        curl_setopt($ch, CURLOPT_TIMEOUT, 15); // Increased Timeout

        // Cookie Handling (Vital for Yahoo)
        // Use a local cookie file to avoid permission issues in temp dir on shared hosting
        $cookie_file = __DIR__ . '/../cookie_jar.txt';
        curl_setopt($ch, CURLOPT_COOKIEJAR, $cookie_file);
        curl_setopt($ch, CURLOPT_COOKIEFILE, $cookie_file);

        // Rotation of UAs
        $agents = [
            'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36',
            'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.2 Safari/605.1.15',
            'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:121.0) Gecko/20100101 Firefox/121.0',
            'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36'
        ];
        $ua = $agents[array_rand($agents)];

        $headers = [
            "User-Agent: " . $ua,
            "Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8",
            "Accept-Language: en-US,en;q=0.9",
            "Accept-Encoding: gzip, deflate, br",
            "Connection: keep-alive",
            "Upgrade-Insecure-Requests: 1",
            "Sec-Fetch-Dest: document",
            "Sec-Fetch-Mode: navigate",
            "Sec-Fetch-Site: none",
            "Sec-Fetch-User: ?1",
            "Referer: https://finance.yahoo.com/", // Critical for some checks
            "Origin: https://finance.yahoo.com"
        ];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $err = curl_error($ch);
        curl_close($ch);

        if ($http_code == 200 && $result && strlen($result) > 100) {
            return $result;
        } else {
            file_put_contents($log_file, date('Y-m-d H:i:s') . " - cURL Fail: $url | Code: $http_code | Err: $err\n", FILE_APPEND);
        }
    } else {
        file_put_contents($log_file, date('Y-m-d H:i:s') . " - cURL Not Available\n", FILE_APPEND);
    }

    // 2. FALLBACK: file_get_contents
    if (ini_get('allow_url_fopen')) {
        $opts = [
            "http" => [
                "method" => "GET",
                "header" => "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64)\r\n" .
                    "Accept: */*\r\n"
            ]
        ];
        $context = stream_context_create($opts);
        $result = @file_get_contents($url, false, $context);
        if ($result && strlen($result) > 100) {
            return $result;
        } else {
            $error = error_get_last();
            file_put_contents($log_file, date('Y-m-d H:i:s') . " - FGC Fail: " . ($error['message'] ?? 'Unknown') . "\n", FILE_APPEND);
        }
    } else {
        file_put_contents($log_file, date('Y-m-d H:i:s') . " - allow_url_fopen is OFF\n", FILE_APPEND);
    }

    return false;
}
?>