<?php
// core/file_handler.php
// Safe File Operations with Locking

function safe_file_write($filename, $data)
{
    $fp = @fopen($filename, 'c'); // 'c' mode: Open for writing only; use existing content or create
    if ($fp) {
        if (flock($fp, LOCK_EX)) { // Acquire exclusive lock
            ftruncate($fp, 0);      // Truncate file
            fwrite($fp, $data);
            fflush($fp);            // Flush output
            flock($fp, LOCK_UN);    // Release lock
        } else {
            // Couldn't lock, handle error or wait?
            // For now, silent fail or log error
            error_log("Failed to lock file: $filename");
        }
        fclose($fp);
        return true;
    }
    return false;
}

function safe_file_read($filename)
{
    if (!file_exists($filename))
        return null;
    $fp = fopen($filename, 'r');
    $content = '';
    if ($fp) {
        if (flock($fp, LOCK_SH)) { // Shared lock
            $size = filesize($filename);
            if ($size > 0) {
                $content = fread($fp, $size);
            } else {
                $content = '{}'; // Empty file
            }
            flock($fp, LOCK_UN);
        }
        fclose($fp);
    }
    return $content;
}
?>