<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - AutoTrade AI</title>
    <style>
        body {
            background-color: #0b0e11;
            color: #d1d4dc;
            font-family: 'Inter', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }

        .login-card {
            background: #1b2029;
            padding: 40px;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.5);
            width: 100%;
            max-width: 400px;
            border: 1px solid #2b313f;
            text-align: center;
        }

        .logo {
            font-size: 1.5rem;
            font-weight: 800;
            color: #fff;
            margin-bottom: 30px;
            letter-spacing: 1px;
        }

        .logo span {
            color: #3b82f6;
        }

        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }

        label {
            display: block;
            margin-bottom: 8px;
            color: #888;
            font-size: 0.9rem;
        }

        input {
            width: 100%;
            padding: 12px;
            background: #0b0e11;
            border: 1px solid #2b313f;
            border-radius: 4px;
            color: #fff;
            font-size: 1rem;
            box-sizing: border-box;
            transition: border-color 0.2s;
        }

        input:focus {
            border-color: #3b82f6;
            outline: none;
        }

        .btn-login {
            background: #3b82f6;
            color: #fff;
            border: none;
            width: 100%;
            padding: 12px;
            border-radius: 4px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s;
        }

        .btn-login:hover {
            background: #2563eb;
        }

        .error-msg {
            color: #f6465d;
            font-size: 0.9rem;
            margin-top: 15px;
            display: none;
        }
    </style>
</head>

<body>

    <div class="login-card">
        <div class="logo">AUTO<span>TRADE</span>.AI</div>
        <form id="loginForm">
            <div class="form-group">
                <label>Username</label>
                <input type="text" id="username" name="username" required placeholder="Enter username">
            </div>
            <div class="form-group">
                <label>Password</label>
                <input type="password" id="password" name="password" required placeholder="Enter password">
            </div>
            <button type="submit" class="btn-login" id="btnLogin">Secure Login</button>
            <div class="error-msg" id="errorMsg">Invalid Credentials</div>
        </form>
        <div style="margin-top: 20px; font-size: 0.8rem; color: #555;">
            Protected by Level 6.2 Security System
        </div>
        <div style="margin-top: 15px; font-size: 0.9rem; color: #888;">
            Don't have an account? <a href="signup.php"
                style="color: #3b82f6; text-decoration: none; font-weight: 600;">Create Account</a>
        </div>
    </div>

    <script>
        document.getElementById('loginForm').addEventListener('submit', async function (e) {
            e.preventDefault();
            const btn = document.getElementById('btnLogin');
            const err = document.getElementById('errorMsg');

            btn.disabled = true;
            btn.innerText = "Verifying...";
            err.style.display = 'none';

            const formData = new FormData(this);

            try {
                const res = await fetch('api.php?action=login', {
                    method: 'POST',
                    body: formData
                });
                const data = await res.json();

                if (data.status === 'success') {
                    // Redirect based on role
                    if (data.role === 'admin') {
                        window.location.href = 'admin.php';
                    } else {
                        window.location.href = 'index.php';
                    }
                } else {
                    err.innerText = data.error || "Login Failed";
                    err.style.display = 'block';
                    btn.disabled = false;
                    btn.innerText = "Secure Login";
                }
            } catch (e) {
                console.error(e);
                err.innerText = "Connection Error";
                err.style.display = 'block';
                btn.disabled = false;
                btn.innerText = "Secure Login";
            }
        });
    </script>
</body>

</html>