<?php
// master_debug.php - Yahoo API Diagnostic Tool
header('Content-Type: text/html; charset=utf-8');

// Use the same engine as the app
require_once __DIR__ . '/trade_engine.php';

$symbol = $_GET['symbol'] ?? 'ZOMATO.NS';
$interval = $_GET['interval'] ?? '5m';
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Master Debug:
        <?php echo htmlspecialchars($symbol); ?>
    </title>
    <style>
        body {
            background: #1b2029;
            color: #ccc;
            font-family: monospace;
            padding: 20px;
        }

        h1 {
            color: #fff;
            border-bottom: 2px solid #3b82f6;
            padding-bottom: 10px;
        }

        .box {
            background: #000;
            padding: 15px;
            border: 1px solid #444;
            margin-bottom: 20px;
            overflow-x: auto;
        }

        .success {
            color: #0ecb81;
        }

        .error {
            color: #f6465d;
        }

        input,
        button {
            padding: 10px;
            background: #222;
            border: 1px solid #555;
            color: #fff;
        }

        button {
            cursor: pointer;
            background: #3b82f6;
            font-weight: bold;
        }
    </style>
</head>

<body>

    <h1>🔍 API Diagnostic Tool</h1>

    <form method="GET" style="margin-bottom: 20px;">
        <input type="text" name="symbol" value="<?php echo htmlspecialchars($symbol); ?>"
            placeholder="Symbol (e.g. ZOMATO.NS)">
        <select name="interval" style="padding: 10px; background: #222; border: 1px solid #555; color: #fff;">
            <option value="1m" <?php if ($interval == '1m')
                echo 'selected'; ?>>1 Minute</option>
            <option value="5m" <?php if ($interval == '5m')
                echo 'selected'; ?>>5 Minutes</option>
            <option value="1d" <?php if ($interval == '1d')
                echo 'selected'; ?>>1 Day</option>
        </select>
        <button type="submit">SEARCH</button>
    </form>

    <h2>1. Raw URL Check</h2>
    <div class="box">
        <?php
        $range = '1mo'; // Fallback
        if (in_array($interval, ['1m', '2m', '5m', '15m', '30m', '90m'])) {
            $range = '5d';
        } elseif ($interval === '1h') {
            $range = '1y';
        } elseif ($interval === '1d') {
            $range = '5y';
        }

        $url = "https://query1.finance.yahoo.com/v8/finance/chart/" . urlencode($symbol) . "?interval=" . $interval . "&range=" . $range;
        echo "TARGET URL: <a href='$url' target='_blank' style='color:#3b82f6;'>$url</a><br>";
        ?>
    </div>

    <h2>2. Fetch Result & Raw Debug</h2>
    <div class="box">
        <?php
        // Manually fetch using the engine's hidden logic
        // We will call the fetcher directly to see raw output
        $url = "https://query1.finance.yahoo.com/v8/finance/chart/" . urlencode($symbol) . "?interval=" . $interval . "&range=1mo"; // Simplified Check
        $raw = fetch_url_secure($url);

        echo "<strong>Raw Response Length: </strong>" . strlen($raw) . " chars<br>";

        if (strlen($raw) < 500) {
            echo "<strong>Raw Output (Short):</strong> <pre>" . htmlspecialchars($raw) . "</pre><br>";
        } else {
            echo "<strong>Raw Output:</strong> (Too long to display, seems like valid data)<br>";
        }

        $data = run_analysis($symbol, $interval);

        echo "<hr><strong>Engine Status: </strong>";
        if ($data['success']) {
            echo "<span class='success'>SUCCESS</span><br>";
            echo "<strong>Price: </strong> " . $data['price'] . "<br>";
            echo "<strong>Candles: </strong> " . count($data['candles']) . "<br>";
            echo "<strong>Last Candle Close: </strong> ";
            if (!empty($data['candles'])) {
                $last = end($data['candles']);
                echo $last['c'];
            } else {
                echo "N/A";
            }
        } else {
            echo "<span class='error'>FAILED</span>";
        }
        ?>
    </div>

    <h2>3. Raw JSON Dump</h2>
    <div class="box">
        <pre><?php print_r($data); ?></pre>
    </div>

</body>

</html>