<?php
// paper/debug_api.php
// DIAGNOSTIC TOOL FOR PAPER TRADING

// 1. Construct URL to Main API
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$domain = $_SERVER['HTTP_HOST'];
// Adjust path: Go up one level from 'paper/' to root, then to 'api/trade.php'
// Current: /trading/paper/debug_api.php -> /trading/api/trade.php
$path = dirname(dirname($_SERVER['REQUEST_URI'])) . "/api/trade.php";
$url = $protocol . $domain . $path . "?action=analyze&symbol=RELIANCE.NS&interval=5m";

$token = '7f8a9d1e2b3c4f5a6b7c8d9e0f1a2b3c4d5e6f7a8b9c0d1e2f3a4b5c6d7e8f9';

echo "<html><body style='background:#111; color:#fff; font-family:monospace; padding:20px;'>";
echo "<h2>🕵️ Paper Trading API Diagnostic</h2>";
echo "<p><b>Target URL:</b> <a href='$url' target='_blank' style='color:#0ecb81'>$url</a></p>";
echo "<p><b>Authentication Token:</b> $token</p>";
echo "<hr style='border-color:#333'>";

// 2. Execute Request
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
// Simulate exactly what logic.js does
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'X-API-TOKEN: ' . $token,
    'Content-Type: application/json',
    'User-Agent: AutoTradeDebug/1.0'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_error($ch);
curl_close($ch);

// 3. Output Results
echo "<h3>1. Connection Status</h3>";
if ($httpCode == 200) {
    echo "<p style='color:#0ecb81'>✅ HTTP 200 OK</p>";
} else {
    echo "<p style='color:#f6465d'>❌ HTTP Code: $httpCode</p>";
}

if ($curlError) {
    echo "<p style='color:#f6465d'>CURL Error: $curlError</p>";
}

echo "<h3>2. Raw Response Body</h3>";
// TextArea to see hidden characters/HTML
echo "<textarea style='width:100%; height:200px; background:#222; color:#0f0; border:1px solid #444; padding:10px;'>";
echo htmlspecialchars($response);
echo "</textarea>";

echo "<h3>3. JSON Validation</h3>";
$json = json_decode($response, true);

if ($json) {
    echo "<p style='color:#0ecb81'>✅ Valid JSON Response Detected</p>";

    // Check specific keys logic.js needs
    echo "<ul>";

    // Symbol Support
    echo "<li>Price: " . ($json['price'] ?? '<span style="color:red">MISSING</span>') . "</li>";

    // Candles Check
    if (!empty($json['candles'])) {
        $c_count = count($json['candles']);
        echo "<li>Candles: <span style='color:#0ecb81'>$c_count candles found</span></li>";

        // Inspect first candle keys
        $first = $json['candles'][0];
        echo "<li>Candle Keys: " . implode(", ", array_keys($first)) . " (Logic.js needs c,h,l,o OR Close,High,Low,Open)</li>";
    } else {
        echo "<li>Candles: <span style='color:red'>MISSING or EMPTY</span></li>";
    }

    // AI Check
    if (!empty($json['analysis']['intraday'])) {
        echo "<li>AI Signal: " . $json['analysis']['intraday']['signal'] . "</li>";
    } else {
        echo "<li>AI Analysis: <span style='color:red'>MISSING</span></li>";
    }

    echo "</ul>";

    // Dump
    echo "<details><summary style='cursor:pointer; color:#aaa'>View Full JSON Array</summary>";
    echo "<pre>";
    print_r($json);
    echo "</pre></details>";

} else {
    echo "<p style='color:#f6465d'>❌ Invalid JSON</p>";
    echo "<p>JSON Error: " . json_last_error_msg() . "</p>";
    echo "<p><b>Diagnosis:</b> If you see HTML above (like 'Login' or 'Warning'), the API request is being redirected or blocked.</p>";
}

echo "</body></html>";
?>