<?php
// server_diag_full.php
// MASTER DIAGNOSTIC TOOL FOR TRADING APP
// Run this on your live server to find the root cause.
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<!DOCTYPE html><html><head><style>
body { font-family: monospace; background: #121212; color: #0f0; padding: 20px; }
.box { border: 1px solid #333; padding: 15px; margin-bottom: 20px; background: #1a1a1a; }
h2 { color: #fff; border-bottom: 1px solid #555; padding-bottom: 5px; }
.fail { color: #ff3333; font-weight: bold; }
.pass { color: #00ff00; font-weight: bold; }
.warn { color: orange; font-weight: bold; }
</style></head><body>";

echo "<h1>🛠️ AUTO-TRADE AI SERVER DIAGNOSTIC V2</h1>";
echo "<p>Time: " . date("Y-m-d H:i:s") . " | PHP Version: " . phpversion() . "</p>";

// 1. FILE SYSTEM CHECK
echo "<div class='box'><h2>1. File System & Permissions</h2>";
$files = [
    'users.json',
    'trade_history.json',
    'core/fetch_engine.php',
    'trade_engine.php',
    'api.php',
    'ai/market_state.php'
];

foreach ($files as $f) {
    if (file_exists(__DIR__ . '/' . $f)) {
        echo "$f: <span class='pass'>FOUND</span>";
        if (strpos($f, '.json') !== false) {
            if (is_writable(__DIR__ . '/' . $f)) {
                echo " | <span class='pass'>WRITABLE</span>";
            } else {
                echo " | <span class='fail'>NOT WRITABLE</span> (Fix permissions)";
            }
        }
        echo "<br>";
    } else {
        echo "$f: <span class='fail'>MISSING</span><br>";
    }
}
echo "</div>";

// 2. EXTENSION CHECK
echo "<div class='box'><h2>2. Critical PHP Extensions</h2>";
$exts = ['curl', 'json', 'mbstring', 'openssl'];
foreach ($exts as $e) {
    if (extension_loaded($e)) {
        echo "$e: <span class='pass'>INSTALLED</span><br>";
    } else {
        echo "$e: <span class='fail'>MISSING</span> (Critical)<br>";
    }
}
echo "</div>";

// 3. CONNECTIVITY CHECK (The Real Test)
echo "<div class='box'><h2>3. Yahoo Finance Connectivity (US Market)</h2>";

function test_url($url, $method)
{
    echo "Testing $url with <b>$method</b>...<br>";
    $start = microtime(true);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    // HUMAN HEADERS (Crucial)
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36');

    if ($method === 'COOKIE') {
        $cookie_file = sys_get_temp_dir() . '/cookie_test.txt';
        curl_setopt($ch, CURLOPT_COOKIEJAR, $cookie_file);
        curl_setopt($ch, CURLOPT_COOKIEFILE, $cookie_file);
    }

    $res = curl_exec($ch);
    $info = curl_getinfo($ch);
    $err = curl_error($ch);
    curl_close($ch);

    $time = round(microtime(true) - $start, 2);

    if ($info['http_code'] == 200 && strlen($res) > 500) {
        echo "Result: <span class='pass'>SUCCESS</span> (HTTP 200) | Time: {$time}s | Size: " . strlen($res) . " bytes<br>";
        return true;
    } else {
        echo "Result: <span class='fail'>FAILED</span> | HTTP Code: " . $info['http_code'] . " | Time: {$time}s<br>";
        if ($err)
            echo "cURL Error: $err<br>";
        echo "Response Snippet: " . htmlspecialchars(substr($res, 0, 200)) . "...<br>";
        return false;
    }
}

// Check AAPL (US)
$url_us = "https://query1.finance.yahoo.com/v8/finance/chart/AAPL?interval=1d&range=5d";
$us_ok = test_url($url_us, 'BASIC');

// Check Indices (Often faulty)
echo "<hr>";
$url_idx = "https://query1.finance.yahoo.com/v8/finance/chart/%5EGSPC?interval=1d&range=5d";
$idx_ok = test_url($url_idx, 'BASIC');

echo "</div>";

// 4. APP INTEGRATION TEST
echo "<div class='box'><h2>4. Application Logic Test</h2>";
if (file_exists('trade_engine.php')) {
    include_once 'trade_engine.php';
    if (function_exists('fetch_yahoo_data')) {
        echo "Function 'fetch_yahoo_data' <span class='pass'>FOUND</span>.<br>";
        echo "Attempting Internal Fetch for AAPL...<br>";

        $data = fetch_yahoo_data('AAPL', '1m'); // Try 1m data
        if ($data && $data['success']) {
            echo "Internal Fetch: <span class='pass'>SUCCESS</span> | Price: " . $data['price'] . "<br>";
        } else {
            echo "Internal Fetch: <span class='fail'>FAILED</span><br>";
            echo "<pre>";
            print_r($data);
            echo "</pre>";
        }
    } else {
        echo "Function 'fetch_yahoo_data' <span class='fail'>MISSING</span> in trade_engine.php<br>";
    }
} else {
    echo "trade_engine.php <span class='fail'>MISSING</span><br>";
}
echo "</div>";

echo "</body></html>";
?>