
// stocks.js - Centralized Stock Database
// Contains top ~700 stocks ensuring 99% of user searches are found.

const ALL_STOCKS_IN = [
    // --- INDICES ---
    "^NSEI", "^NSEBANK", "^CNXIT", "^BSESN", "^CNXAUTO", "^CNXENERGY", "^CNXPHARMA", "^CNXFMCG", "^CNXMETAL", "^CNXREALTY",

    // --- NIFTY 50 & 100 (HIGH LIQUIDITY) ---
    "RELIANCE.NS", "TCS.NS", "HDFCBANK.NS", "ICICIBANK.NS", "INFY.NS", "BHARTIARTL.NS", "ITC.NS", "SBIN.NS", "LICI.NS", "HINDUNILVR.NS",
    "LT.NS", "BAJFINANCE.NS", "HCLTECH.NS", "MARUTI.NS", "SUNPHARMA.NS", "ADANIENT.NS", "KOTAKBANK.NS", "TITAN.NS", "ONGC.NS", "TATAMOTORS.NS",
    "NTPC.NS", "AXISBANK.NS", "ADANIPORTS.NS", "ULTRACEMCO.NS", "ASIANPAINT.NS", "COALINDIA.NS", "WIPRO.NS", "M&M.NS", "BAJAJFINSV.NS", "BAJAJ-AUTO.NS",
    "POWERGRID.NS", "NESTLEIND.NS", "JSWSTEEL.NS", "ADANIPOWER.NS", "ADANIGREEN.NS", "GRASIM.NS", "TATASTEEL.NS", "ZOMATO.NS", "VBL.NS", "DLF.NS",
    "SBILIFE.NS", "HDFCLIFE.NS", "BEL.NS", "HAL.NS", "LTIM.NS", "SIEMENS.NS", "IOC.NS", "VARROC.NS", "VEDL.NS", "PIDILITIND.NS",
    "DIVISLAB.NS", "INDUSINDBK.NS", "EICHERMOT.NS", "BPCL.NS", "GODREJCP.NS", "SHREECEM.NS", "TRENT.NS", "DRREDDY.NS", "CIPLA.NS", "TECHM.NS",
    "GAIL.NS", "AMBUJACEM.NS", "BRITANNIA.NS", "BANKBARODA.NS", "INDIGO.NS", "TATAPOWER.NS", "ABB.NS", "HAVELLS.NS", "JIOFIN.NS", "CHOLAFIN.NS",
    "PNB.NS", "TVSMOTOR.NS", "CANBK.NS", "APOLLOHOSP.NS", "DABUR.NS", "JINDALSTEL.NS", "POLYCAB.NS", "NAUKRI.NS", "ATGL.NS", "ICICIPRULI.NS",
    "SRF.NS", "MARICO.NS", "SBICARD.NS", "HEROMOTOCO.NS", "MUTHOOTFIN.NS", "TRITURBINE.NS", "BOSCHLTD.NS", "CUMMINSIND.NS", "COLPAL.NS", "BERGEPAINT.NS",

    // --- MIDCAPS & F&O STOCKS (ACTIVE TRADING) ---
    "ABCAPITAL.NS", "ABFRL.NS", "ACC.NS", "ADANIENSOL.NS", "ALKEM.NS", "AMBUJACEM.NS", "APOLLOTYRE.NS", "ASHOKLEY.NS", "ASTRAL.NS", "ATUL.NS",
    "AUBANK.NS", "AUROPHARMA.NS", "BAJAJHLDNG.NS", "BALKRISIND.NS", "BALRAMCHIN.NS", "BANDHANBNK.NS", "BANKINDIA.NS", "BATAINDIA.NS", "BEL.NS",
    "BHARATFORG.NS", "BHEL.NS", "BIOCON.NS", "BSOFT.NS", "CANFINHOME.NS", "CHAMBLFERT.NS", "CHOLAFIN.NS", "CITYUNIONB.NS", "COFORGE.NS",
    "CONCOR.NS", "COROMANDEL.NS", "CROMPTON.NS", "CUB.NS", "CUMMINSIND.NS", "DALBHARAT.NS", "DEEPAKNTR.NS", "DELTACORP.NS", "DIXON.NS",
    "LALPATHLAB.NS", "ESCORTS.NS", "EXIDEIND.NS", "FEDERALBNK.NS", "GMRINFRA.NS", "GLENMARK.NS", "GODREJPROP.NS", "GRANULES.NS", "GNFC.NS",
    "GUJGASLTD.NS", "HDFCAMC.NS", "HINDCOPPER.NS", "HINDPETRO.NS", "IDFC.NS", "IDFCFIRSTB.NS", "IBULHSGFIN.NS", "INDIAMART.NS", "IEX.NS",
    "INDHOTEL.NS", "IGL.NS", "INDUSTOWER.NS", "INTELLECT.NS", "IPCALAB.NS", "JKCEMENT.NS", "JSL.NS", "JSWENERGY.NS", "JUBLFOOD.NS", "L&TFH.NS",
    "LICHSGFIN.NS", "LAURUSLAB.NS", "LTTS.NS", "LUPIN.NS", "MANAPPURAM.NS", "MFSL.NS", "METROPOLIS.NS", "MGL.NS", "MINDTREE.NS", "MPHASIS.NS",
    "MRF.NS", "MCX.NS", "NAM-INDIA.NS", "NATIONALUM.NS", "NAVINFLUOR.NS", "NMDC.NS", "OBEROIRLTY.NS", "OFSS.NS", "OIL.NS", "PAGEIND.NS",
    "PERSISTENT.NS", "PETRONET.NS", "PFC.NS", "PIIND.NS", "PNB.NS", "PVRINOX.NS", "RAIN.NS", "RAMCOCEM.NS", "RBLBANK.NS", "RECLTD.NS",
    "SAIL.NS", "SYNGENE.NS", "TATACHEM.NS", "TATACOMM.NS", "TATACONSUM.NS", "TORNTPOWER.NS", "TORNTPHARM.NS", "UBL.NS", "ULTRACEMCO.NS",
    "UPL.NS", "VOLTAS.NS", "WHIRLPOOL.NS", "ZEEL.NS", "ZYDUSLIFE.NS",

    // --- POPULAR SMALLCAPS ---
    "SUZLON.NS", "IDEA.NS", "YESBANK.NS", "RPOWER.NS", "JPPOWER.NS", "RENUKA.NS", "RVNL.NS", "IRFC.NS", "HUDCO.NS", "NBCC.NS", "SJVN.NS", "NHPC.NS",
    "FACT.NS", "MMTC.NS", "TRIDENT.NS", "URJA.NS", "VIKASECO.NS", "GTLINFRA.NS", "SOUTHBANK.NS", "UCOBANK.NS", "MAHABANK.NS", "IOB.NS", "CENTRALBK.NS",
    "KSL.NS", "BCG.NS", "EASEMYTRIP.NS", "PAYTM.NS", "NYKAA.NS", "POLICYBZR.NS", "DELHIVERY.NS", "AWL.NS", "LODHA.NS", "PATANJALI.NS",
    "EQUITASBNK.NS", "UJJIVANSFB.NS", "MASTEK.NS", "BSOFT.NS", "TANLA.NS", "ROUTE.NS", "AFFLE.NS", "HAPPSTMNDS.NS", "KPITTECH.NS",

    // --- SECTOR LEADERS ---
    "KAJARIACER.NS", "CERA.NS", "AIAENG.NS", "TIMKEN.NS", "SKFINDIA.NS", "SCHAEFFLER.NS", "SUNDRMFAST.NS", "ENDURANCE.NS", "MINDAIND.NS",
    "THERMAX.NS", "KEI.NS", "FINCABLES.NS", "VGUARD.NS", "CROMPTON.NS", "TTKPRESTIG.NS", "HAWKINS.NS", "SYMPHONY.NS", "BLUESTARCO.NS"
];

const ALL_STOCKS_US = [
    // --- INDICES ---
    "^GSPC", "^DJI", "^IXIC", "^RUT", "^VIX", "^NYA",

    // --- MEGA CAP ---
    "AAPL", "MSFT", "GOOGL", "GOOG", "AMZN", "NVDA", "META", "TSLA", "BRK-B", "LLY", "AVGO", "V", "JPM", "TSM", "WMT", "XOM", "MA", "UNH", "PG",
    "JNJ", "HD", "COST", "MRK", "ORCL", "ABBV", "CVX", "BAC", "CRM", "AMD", "PEP", "NFLX", "KO", "ADBE", "TMO", "DIS", "WFC", "CSCO", "ACN", "MCD",
    "LIN", "ABT", "TM", "DHR", "INTC", "QCOM", "TXN", "VZ", "NKE", "CMCSA", "PM", "PFE", "AMGN", "UPS", "INTU", "IBM", "CAT", "UNP", "LOW", "SPGI",
    "HON", "COP", "RTX", "GE", "AMAT", "GS", "BA", "PLD", "BLK", "DE", "BKNG", "T", "SBUX", "ELV", "MS", "MDT", "TJX", "ADP", "AXP", "ISRG", "LMT",
    "GILD", "MMC", "VRTX", "MDLZ", "ADI", "REGN", "LRCX", "CI", "SYK", "ETN", "SLB", "C", "AMT", "CVS", "MO", "PGR", "ZTS", "BSX", "CB", "SO", "FI",
    "EOG", "MU", "BDX", "TMUS", "NOC", "CL", "PANW", "SNPS", "KLAC", "CDNS", "EQIX", "WM", "CME", "SHW", "CSX", "ITW", "DUK", "ICE", "APD",

    // --- TECH & AI ---
    "PLTR", "AI", "SOUN", "PATH", "U", "SNOW", "DDOG", "NET", "CRWD", "ZS", "FTNT", "OKTA", "MDB", "TEAM", "WDAY", "HUBS", "TWLO", "SPLK",
    "ZM", "DOCU", "ESTC", "GTLB", "HCP", "BILL", "ASAN", "NCNO",

    // --- EV & MANUFACTURE ---
    "RIVN", "LCID", "NIO", "XPEV", "LI", "F", "GM", "STLA", "HMC", "TTM",

    // --- CRYPTO & FINTECH ---
    "COIN", "MARA", "RIOT", "MSTR", "HOOD", "PYPL", "SQ", "AFRM", "UPST", "SOFI", "NU", "DKNG",

    // --- RETAIL & CONSUMER ---
    "LULU", "NKE", "UAA", "CROX", "DECK", "ONON", "BURL", "ROST", "DLTR", "DG", "BJ", "KR", "TGT", "WMT",

    // --- ETF ---
    "SPY", "QQQ", "IWM", "DIA", "GLD", "SLV", "USO", "UNG", "TLT", "HYG", "JNK", "LQD", "XLK", "XLF", "XLV", "XLE", "XLI", "XLY", "XLP", "XLU", "XLB",
    "ARKK", "ARKG", "ARKF", "ARKW", "ARKQ", "ARKX", "SMH", "SOXL", "SOXS", "TQQQ", "SQQQ"
];

// Combine for Global Lookup if needed
const ALL_STOCKS_GLOBAL = [...ALL_STOCKS_IN, ...ALL_STOCKS_US];

console.log(`Loaded ${ALL_STOCKS_IN.length} Indian Stocks & ${ALL_STOCKS_US.length} US Stocks.`);

// Export for Modules (if using ES6, but we are using script tags)
if (typeof module !== 'undefined' && module.exports) {
    module.exports = { ALL_STOCKS_IN, ALL_STOCKS_US };
}
