<?php
// test_yahoo.php
error_reporting(E_ALL);
ini_set('display_errors', 1);

function test_fetch($symbol)
{
    echo "<h2>Testing Fetch for $symbol</h2>";
    $url = "https://query1.finance.yahoo.com/v8/finance/chart/" . urlencode($symbol) . "?interval=1m&range=1d";
    echo "URL: $url<br>";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    // Explicitly NOT disabling SSL verify initially to see if that's the error
    // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');

    $res = curl_exec($ch);

    if (curl_errno($ch)) {
        echo "<h3 style='color:red;'>cURL Error: " . curl_error($ch) . " (Code: " . curl_errno($ch) . ")</h3>";
    } else {
        echo "<h3 style='color:green;'>Request Successful</h3>";
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        echo "HTTP Code: $code<br>";
        echo "Response Length: " . strlen($res) . "<br>";

        $json = json_decode($res, true);
        if ($json && isset($json['chart']['result'][0])) {
            echo "<b>Data Valid:</b> Yes<br>";
            $price = $json['chart']['result'][0]['meta']['regularMarketPrice'];
            echo "Current Price: $price<br>";
        } else {
            echo "<b>Data Valid:</b> NO (JSON Decode fail or empty)<br>";
            echo "Response Preview: " . htmlspecialchars(substr($res, 0, 500)) . "<br>";
        }
    }
    curl_close($ch);
}

test_fetch('RELIANCE.NS');
?>