<?php
// UNINSTALLER TOOL
// Use this to remove the Trading App files from a specific folder.
// Steps:
// 1. Upload this file to the folder you want to CLEAN (e.g. public_html)
// 2. Run it in browser
// 3. Click "Delete App Files"

$app_files = [
    'admin.php',
    'api.php',
    'app.js',
    'auth.php',
    'chat.php',
    'chat_engine.php',
    'index.php',
    'login.php',
    'mobile.css',
    'nifty_data.php',
    'setup.php',
    'sidebar_content.html',
    'store.json',
    'style.css',
    'test_connection.php',
    'trade_engine.php',
    'trade_history.json',
    'users.json',
    'user_dashboard.php',
    '.htaccess',
    'force_delete.php'
];

echo '<div style="font-family:sans-serif; padding:20px;">';
echo "<h2>App Cleaner / Uninstaller</h2>";
echo "<p>This script checks for Trading App files in: <strong>" . __DIR__ . "</strong></p>";

$found_files = [];
foreach ($app_files as $file) {
    if (file_exists($file)) {
        $found_files[] = $file;
    }
}

if (count($found_files) > 0) {
    echo "<p style='color:red'>" . count($found_files) . " App files found here.</p>";
    echo "<ul style='background:#eee; padding:15px;'>";
    foreach ($found_files as $f)
        echo "<li>$f</li>";
    echo "</ul>";

    echo "<h3>Do you want to delete these files from THIS folder?</h3>";
    echo "<p>(This will ONLY delete the listed files. It will NOT delete folders like 'trading')</p>";

    echo '<form method="POST" onsubmit="return confirm(\'Are you sure? This cannot be undone!\');">
            <input type="hidden" name="confirm" value="yes">
            <input type="submit" value="DELETE APP FILES" style="background:red; color:white; padding:15px; border:none; font-size:16px; cursor:pointer;">
          </form>';

    if (isset($_POST['confirm']) && $_POST['confirm'] == 'yes') {
        echo "<hr>";
        foreach ($found_files as $f) {
            if (@unlink($f)) {
                echo "<div style='color:green'>Deleted: $f</div>";
            } else {
                echo "<div style='color:red'>Failed to delete: $f (Permission Error?)</div>";
                // Try chmod
                @chmod($f, 0777);
                if (@unlink($f))
                    echo "<div style='color:green'>Retry - Deleted: $f</div>";
            }
        }
        echo "<h3>Cleanup Complete. You can now delete this script.</h3>";
    }

} else {
    echo "<h3 style='color:green'>No App Files Found in this directory. It is clean.</h3>";
}
echo '</div>';
?>