<?php
// USER DASHBOARD (Free Plan)
// Concept: Clean "Signal Feed" view. No complex charts.
// Focus: Teasing AI Signals to drive conversion.
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AutoTrade AI | Member Area</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="style.css?v=28_USER_NEW">
    <style>
        /* Specific Styles for User Dashboard */
        body {
            background: #0b0e14;
            color: #fff;
            font-family: 'Inter', sans-serif;
            overflow-y: auto;
        }

        .u-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        /* Header */
        .u-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding-bottom: 20px;
            border-bottom: 1px solid #2b313f;
            margin-bottom: 30px;
        }

        .u-logo {
            font-size: 1.5rem;
            font-weight: 800;
            color: #fff;
        }

        .u-logo span {
            color: #2962ff;
        }

        .u-profile {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .u-badge {
            background: #333;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 0.8rem;
            color: #ccc;
        }

        .u-logout {
            color: #f6465d;
            text-decoration: none;
            font-size: 0.9rem;
            font-weight: 600;
        }

        /* Hero Status */
        .u-hero {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-bottom: 40px;
        }

        .u-card {
            background: #151a24;
            border-radius: 12px;
            padding: 25px;
            border: 1px solid #2b313f;
        }

        .u-title {
            font-size: 0.9rem;
            color: #7e879a;
            margin-bottom: 10px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .u-value {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 5px;
        }

        .u-green {
            color: #0ecb81;
        }

        .u-red {
            color: #f6465d;
        }

        /* Signal Feed */
        .u-feed-title {
            font-size: 1.4rem;
            font-weight: 700;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .u-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
            gap: 20px;
        }

        /* Signal Card */
        .s-card {
            background: #151a24;
            border-radius: 12px;
            border: 1px solid #2b313f;
            overflow: hidden;
            position: relative;
            transition: transform 0.2s;
        }

        .s-card:hover {
            transform: translateY(-5px);
            border-color: #2962ff;
        }

        .s-head {
            background: #1b212d;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 1px solid #2b313f;
        }

        .s-name {
            font-weight: 700;
            font-size: 1.1rem;
        }

        .s-time {
            font-size: 0.8rem;
            color: #7e879a;
        }

        .s-body {
            padding: 20px;
            position: relative;
        }

        /* Blur Effect */
        .s-blur {
            filter: blur(5px);
            opacity: 0.5;
            user-select: none;
        }

        /* Lock Overlay */
        .s-lock {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            background: rgba(21, 26, 36, 0.7);
            z-index: 10;
        }

        .lock-btn {
            background: linear-gradient(90deg, #2962ff, #2979ff);
            color: white;
            border: none;
            padding: 10px 25px;
            border-radius: 30px;
            font-weight: 600;
            cursor: pointer;
            box-shadow: 0 5px 15px rgba(41, 98, 255, 0.4);
            transition: transform 0.2s;
        }

        .lock-btn:hover {
            transform: scale(1.05);
        }

        .s-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 12px;
        }

        .s-label {
            color: #7e879a;
            font-size: 0.9rem;
        }

        .s-val {
            font-weight: 600;
            color: #fff;
        }

        @media (max-width: 768px) {
            .u-header {
                flex-direction: column;
                gap: 15px;
            }

            .u-hero {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>

<body>

    <div class="u-container">
        <!-- Header -->
        <header class="u-header">
            <div class="u-logo">AUTO<span>TRADE</span>.AI</div>
            <div class="u-profile">
                <span class="u-badge">Free Plan</span>
                <span style="color:#7e879a;">Hello,
                    <?php echo htmlspecialchars($currUser['username']); ?>
                </span>
                <a href="api.php?action=logout" class="u-logout">Logout</a>
            </div>
        </header>

        <!-- Hero Stats -->
        <div class="u-hero">
            <div class="u-card">
                <div class="u-title">Market Sentiment</div>
                <div class="u-value u-green">BULLISH</div>
                <div style="color:#7e879a; font-size:0.9rem;">AI Confidence: 78% Priority</div>
            </div>
            <div class="u-card">
                <div class="u-title">Active AI Interactions</div>
                <div class="u-value">1,240</div>
                <div style="color:#7e879a; font-size:0.9rem;">Scanning 50 Stocks Realtime</div>
            </div>
        </div>

        <!-- Feed -->
        <div class="u-feed-title">
            Live AI Signals
            <button
                style="background:transparent; border:1px solid #2b313f; color:#fff; padding:8px 15px; border-radius:6px; cursor:pointer;">Refresh
                Feed</button>
        </div>

        <div class="u-grid">
            <!-- Loop Mock Cards -->
            <?php
            $stocks = ['RELIANCE', 'TCS', 'HDFCBANK', 'INFY', 'SBIN', 'ADANIENT'];
            foreach ($stocks as $stk):
                $action = rand(0, 1) ? 'BUY' : 'SELL';
                $color = $action == 'BUY' ? '#0ecb81' : '#f6465d';
                ?>
                <div class="s-card">
                    <div class="s-head">
                        <span class="s-name">
                            <?php echo $stk; ?>
                        </span>
                        <span class="s-time">Just now</span>
                    </div>
                    <div class="s-body">
                        <!-- Blurred Content -->
                        <div class="s-blur">
                            <div class="s-row">
                                <span class="s-label">Signal</span>
                                <span class="s-val" style="color:<?php echo $color; ?>">
                                    <?php echo $action; ?>
                                </span>
                            </div>
                            <div class="s-row">
                                <span class="s-label">Entry Zone</span>
                                <span class="s-val">₹2450.00</span>
                            </div>
                            <div class="s-row">
                                <span class="s-label">Target</span>
                                <span class="s-val">₹2500.00</span>
                            </div>
                            <div class="s-row">
                                <span class="s-label">Stoploss</span>
                                <span class="s-val">₹2400.00</span>
                            </div>
                        </div>

                        <!-- Lock Overlay -->
                        <div class="s-lock">
                            <div style="margin-bottom:15px; font-weight:600; color:#fff;">Premium Signal</div>
                            <button class="lock-btn">Unlock Now</button>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

</body>

</html>