<?php require 'auth.php';
checkAdmin(); ?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Admin Command Center | AutoTrade.AI</title>
    <style>
        :root {
            --bg: #0b0e11;
            --card-bg: #151a21;
            --primary: #3b82f6;
            --accent: #0ecb81;
            --danger: #f6465d;
            --text: #e2e8f0;
            --text-muted: #94a3b8;
            --border: #2b313f;
        }

        body {
            margin: 0;
            font-family: 'Inter', sans-serif;
            background: var(--bg);
            color: var(--text);
        }

        /* Premium Header */
        header {
            background: rgba(21, 26, 33, 0.8);
            backdrop-filter: blur(10px);
            padding: 15px 30px;
            border-bottom: 1px solid var(--border);
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .logo {
            font-weight: 800;
            font-size: 1.2rem;
            letter-spacing: 1px;
        }

        .logo span {
            color: var(--primary);
        }

        /* Container */
        .container {
            max-width: 1200px;
            margin: 40px auto;
            padding: 0 20px;
        }

        /* Card Design */
        .card {
            background: var(--card-bg);
            border: 1px solid var(--border);
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
            margin-bottom: 30px;
        }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        h2 {
            margin: 0;
            font-size: 1.25rem;
            font-weight: 600;
            color: #fff;
        }

        /* Table Design */
        table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
        }

        th {
            text-align: left;
            padding: 15px;
            color: var(--text-muted);
            font-size: 0.8rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            border-bottom: 1px solid var(--border);
        }

        td {
            padding: 15px;
            border-bottom: 1px solid #1e2329;
            font-size: 0.9rem;
        }

        tr:last-child td {
            border-bottom: none;
        }

        tr:hover td {
            background: rgba(59, 130, 246, 0.05);
        }

        /* Badges */
        .badge {
            padding: 4px 10px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
        }

        .badge-admin {
            background: rgba(59, 130, 246, 0.2);
            color: var(--primary);
        }

        .badge-user {
            background: rgba(148, 163, 184, 0.2);
            color: var(--text-muted);
        }

        .badge-premium {
            background: rgba(255, 215, 0, 0.15);
            color: #ffd700;
            border: 1px solid rgba(255, 215, 0, 0.3);
        }

        .badge-free {
            background: rgba(255, 255, 255, 0.1);
            color: #fff;
        }

        .badge-active {
            background: rgba(14, 203, 129, 0.2);
            color: var(--accent);
        }

        .badge-blocked {
            background: rgba(246, 70, 93, 0.2);
            color: var(--danger);
        }

        /* Buttons */
        .btn {
            padding: 8px 16px;
            border-radius: 6px;
            cursor: pointer;
            border: none;
            font-weight: 500;
            transition: all 0.2s;
            font-size: 0.9rem;
        }

        .btn-primary {
            background: var(--primary);
            color: #fff;
            box-shadow: 0 0 15px rgba(59, 130, 246, 0.4);
        }

        .btn-primary:hover {
            transform: translateY(-1px);
            box-shadow: 0 0 20px rgba(59, 130, 246, 0.6);
        }

        .btn-danger {
            background: rgba(246, 70, 93, 0.1);
            color: var(--danger);
            border: 1px solid rgba(246, 70, 93, 0.3);
        }

        .btn-danger:hover {
            background: rgba(246, 70, 93, 0.2);
        }

        .btn-sm {
            padding: 4px 10px;
            font-size: 0.8rem;
            margin-right: 5px;
        }

        /* Modal */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.8);
            z-index: 1000;
            backdrop-filter: blur(5px);
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background: #1e2329;
            width: 400px;
            padding: 30px;
            border-radius: 12px;
            border: 1px solid var(--border);
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.5);
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            font-size: 0.85rem;
            color: var(--text-muted);
        }

        input,
        select {
            width: 100%;
            padding: 12px;
            background: #0b0e11;
            border: 1px solid var(--border);
            color: #fff;
            border-radius: 6px;
            outline: none;
            box-sizing: border-box;
        }

        input:focus {
            border-color: var(--primary);
        }
    </style>
</head>

<body>

    <header>
        <div class="logo">AUTO<span>TRADE</span>.AI <small style="color:#666; font-size:0.7em;">COMMAND</small></div>
        <div>
            <a href="index.php" class="btn btn-primary" style="text-decoration:none; margin-right:10px;">Open Terminal
                ➜</a>
            <a href="api.php?action=logout" class="btn btn-danger" style="text-decoration:none;">Logout</a>
        </div>
    </header>

    <div class="container">

        <!-- User Management Card -->
        <div class="card">
            <div class="card-header">
                <h2>👥 User Management</h2>
                <button class="btn btn-primary" onclick="openAddUser()">+ New User</button>
            </div>

            <table id="userTable">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>User</th>
                        <th>Role</th>
                        <th>Plan</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>

    </div>

    <!-- AI Control Center -->
    <div class="card" style="margin-top: 30px; border: 1px solid rgba(14, 203, 129, 0.3);">
        <div class="card-header">
            <h2 style="color: var(--accent);">🧠 AI Control Center</h2>
        </div>
        <p style="color: #888; margin-bottom: 20px;">Manually trigger the AI's self-learning and outcome assessment
            protocols.</p>
        <div style="display: flex; gap: 15px;">
            <button class="btn btn-primary" onclick="checkOutcomes()" style="background: var(--accent); color: #000;">🤖
                Auto-Grade Outcomes</button>
            <button class="btn btn-primary" onclick="triggerAI()" style="background: #a855f7;">🧠 Deep Learn</button>
        </div>
    </div>

    </div>

    <!-- Modal -->
    <div id="userModal" class="modal">
        <div class="modal-content">
            <h3
                style="margin-top:0; color:#fff; border-bottom:1px solid #333; padding-bottom:15px; margin-bottom:20px;">
                User Profile</h3>
            <form id="userForm">
                <input type="hidden" id="editUserId" name="id">
                <div class="form-group">
                    <label>Username</label>
                    <input type="text" id="mUsername" name="username" required placeholder="Enter username">
                </div>
                <div class="form-group">
                    <label>Password <small>(Leave empty to keep current)</small></label>
                    <input type="text" id="mPassword" name="password" placeholder="New Password">
                </div>
                <div class="row" style="display:flex; gap:15px;">
                    <div class="form-group" style="flex:1">
                        <label>Role</label>
                        <select id="mRole" name="role">
                            <option value="user">User</option>
                            <option value="admin">Admin</option>
                        </select>
                    </div>
                    <div class="form-group" style="flex:1">
                        <label>Plan</label>
                        <select id="mPlan" name="plan">
                            <option value="free">Free</option>
                            <option value="premium">Premium</option>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label>Status</label>
                    <select id="mStatus" name="status">
                        <option value="active">Active</option>
                        <option value="blocked">Blocked</option>
                    </select>
                </div>
                <div style="display:flex; justify-content: flex-end; gap: 10px; margin-top:30px;">
                    <button type="button" class="btn btn-danger" onclick="closeModal()">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        // --- USER MANAGEMENT LOGIC ---
        async function loadUsers() {
            try {
                const res = await fetch('api.php?action=get_users&t=' + Date.now());
                const users = await res.json();
                const tbody = document.querySelector('#userTable tbody');
                tbody.innerHTML = '';

                if (!Array.isArray(users)) return;

                users.forEach(u => {
                    const tr = document.createElement('tr');
                    tr.innerHTML = `
                    <td style="color:#666">#${u.id}</td>
                    <td style="font-weight:600; color:#fff;">${u.username}</td>
                    <td><span class="badge badge-${u.role}">${u.role}</span></td>
                    <td><span class="badge badge-${u.plan}">${u.plan}</span></td>
                    <td><span class="badge badge-${u.status}">${u.status}</span></td>
                    <td>
                        <button class="btn btn-primary btn-sm" onclick='openEdit(${JSON.stringify(u)})'>Edit</button>
                        ${u.id != 1 ? `<button class="btn btn-danger btn-sm" onclick="deleteUser(${u.id})">Delete</button>` : ''}
                    </td>
                `;
                    tbody.appendChild(tr);
                });
            } catch (e) { console.error(e); }
        }

        async function deleteUser(id) {
            if (!confirm('Are you sure? This cannot be undone.')) return;
            const fd = new FormData();
            fd.append('id', id);
            const res = await fetch('api.php?action=delete_user', { method: 'POST', body: fd });
            const d = await res.json();
            if (d.success) loadUsers();
            else alert(d.error);
        }

        function openAddUser() {
            document.getElementById('editUserId').value = '';
            document.getElementById('userForm').reset();
            document.getElementById('userModal').style.display = 'flex';
        }

        function openEdit(u) {
            document.getElementById('editUserId').value = u.id;
            document.getElementById('mUsername').value = u.username;
            document.getElementById('mPassword').value = '';
            document.getElementById('mRole').value = u.role;
            document.getElementById('mPlan').value = u.plan;
            document.getElementById('mStatus').value = u.status;
            document.getElementById('userModal').style.display = 'flex';
        }

        function closeModal() {
            document.getElementById('userModal').style.display = 'none';
            document.getElementById('userForm').reset();
        }

        // Use "function" declaration to be safer with hoisting
        document.getElementById('userForm').onsubmit = async function (e) {
            e.preventDefault();
            const fd = new FormData(this);
            const id = fd.get('id'); // Get ID from name attribute
            const action = id ? 'edit_user' : 'add_user';

            // Manual append if needed or just pass FD
            // For x-www-form-urlencoded compatibility in simple PHP setups:
            const searchParams = new URLSearchParams();
            for (const pair of fd) {
                searchParams.append(pair[0], pair[1]);
            }

            // Explicitly set ID for add/edit logic if missing in loop
            if (id) searchParams.set('id', id);

            const res = await fetch('api.php?action=' + action, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: searchParams
            });
            const d = await res.json();
            if (d.success) {
                closeModal();
                loadUsers();
            } else {
                alert(d.error || 'Operation Failed');
            }
        };

        // Initial Load
        loadUsers();

        // --- AI LOGIC ---
        async function checkOutcomes() {
            const btn = document.querySelector('button[onclick="checkOutcomes()"]');
            if (btn) {
                btn.innerText = "Checking...";
                btn.disabled = true;
            }

            try {
                const res = await fetch('api.php?action=assess_outcomes');
                const text = await res.text();
                try {
                    const data = JSON.parse(text);
                    if (data.success) {
                        alert(`Check Complete! Updated ${data.updated} trades.`);
                    } else {
                        alert("Error: " + (data.msg || "Unknown"));
                    }
                } catch (e) {
                    alert("Server Error: " + text.substring(0, 100));
                }
            } catch (err) {
                console.error(err);
                alert("Network Request Failed");
            }

            if (btn) {
                btn.innerText = "🤖 Auto-Grade Outcomes";
                btn.disabled = false;
            }
        }

        async function triggerAI() {
            const btn = document.querySelector('button[onclick="triggerAI()"]');
            btn.innerText = "Learning...";
            btn.disabled = true;

            try {
                const res = await fetch('api.php?action=trigger_learning');
                const data = await res.json();
                if (data.status === 'Success') {
                    alert(`Deep Learning Complete!\nAssessed: ${data.learned_from} trades.\nStrategy Weights Updated.`);
                } else {
                    alert("Error: " + data.status);
                }
            } catch (err) {
                alert("Network Error");
            }

            btn.innerText = "🧠 Deep Learn";
            btn.disabled = false;
        }
    </script>
</body>

</html>