<?php
// ai/timeframe_master.php
// LEVEL 9: MULTI-TIMEFRAME MASTER
// Strict Rule: HTF (Higher Timeframe) must confirm LTF (Lower Timeframe)

function check_timeframe_alignment($ltf_signal, $htf_signal)
{
    // 1. Map Signals to Direction (1, -1, 0)
    $l_dir = get_dir($ltf_signal);
    $h_dir = get_dir($htf_signal);

    // 2. Strict Logic
    // If HTF is Neutral (0), we allow LTF (Scalping allowed in ranging HTF if LTF is strong)
    // But if HTF is OPPOSITE to LTF, we BLOCK.

    if ($h_dir != 0 && $l_dir != 0 && $h_dir != $l_dir) {
        return [
            "start_trade" => false,
            "reason" => "❌ Timeframe Conflict: HTF " . $htf_signal . " vs LTF " . $ltf_signal
        ];
    }

    // Bonus: If Aligned
    if ($h_dir != 0 && $h_dir == $l_dir) {
        return [
            "start_trade" => true,
            "reason" => "✅ Multi-Timeframe Alignment",
            "boost" => 10 // Confidence boost
        ];
    }

    // Default
    return ["start_trade" => true, "reason" => "HTF Neutral", "boost" => 0];
}

function get_dir($sig)
{
    if ($sig === 'BUY')
        return 1;
    if ($sig === 'SELL')
        return -1;
    return 0;
}
?>