<?php
// ai/trade_quality.php
// STAGE 2: DECISION ACCURACY (PART 2)
// Calculates a 'Quality Score' (0-100) to filter distinct from Confidence.

function calculate_trade_quality($details)
{
    // $details contains: { trend_strength, volume_ratio, rr_ratio, structure_score }

    $score = 50; // Base

    // 1. Trend Quality
    if ($details['trend_strength'] > 0.8)
        $score += 20;
    elseif ($details['trend_strength'] > 0.5)
        $score += 10;

    // 2. Volume Quality
    if ($details['volume_ratio'] > 2.0)
        $score += 15;
    elseif ($details['volume_ratio'] > 1.2)
        $score += 10;
    elseif ($details['volume_ratio'] < 0.8)
        $score -= 10;

    // 3. Risk Reward Quality
    if ($details['rr'] > 2.5)
        $score += 15;
    elseif ($details['rr'] > 1.5)
        $score += 10;
    elseif ($details['rr'] < 1.0)
        $score -= 30; // Terrible RR kills quality

    // 4. Cleanliness (Candle bodies) - Simulated
    // If we had Heikin Ashi or Doji detection, we'd use it.
    // For now, we assume standard unless marked 'Choppy'.

    return min(100, max(0, $score));
}
?>