<?php
require 'auth.php';
checkLogin();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AI Guru Chat | Market Mentor</title>
    <link rel="stylesheet" href="style.css?v=<?php echo time(); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* Standalone Chat Specific Styles */
        body {
            background: #0b0e11;
            color: #fff;
            height: 100vh;
            overflow: hidden;
            display: flex;
            flex-direction: row;
            margin: 0;
            font-family: 'Inter', sans-serif;
        }

        .chat-sidebar {
            width: 200px;
            background: #131722;
            border-right: 1px solid #2b313f;
            display: flex;
            flex-direction: column;
        }

        .sidebar-header {
            padding: 15px;
            font-weight: 700;
            color: #3b82f6;
            border-bottom: 1px solid #2b313f;
            font-size: 0.9rem;
            letter-spacing: 0.5px;
        }

        .quick-stocks {
            flex: 1;
            overflow-y: auto;
        }

        .quick-item {
            padding: 12px 15px;
            border-bottom: 1px solid #1b2029;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            font-size: 0.85rem;
            color: #cfd3da;
            transition: background 0.2s;
        }

        .quick-item:hover {
            background: #1b2029;
            color: #fff;
        }

        .chat-container {
            flex: 1;
            display: flex;
            flex-direction: column;
        }

        .chat-header-bar {
            padding: 15px 20px;
            background: #131722;
            border-bottom: 1px solid #2b313f;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .stock-context-box {
            display: flex;
            align-items: center;
            gap: 10px;
            background: #0b0e11;
            padding: 5px 10px;
            border-radius: 4px;
            border: 1px solid #2b313f;
        }

        #contextStock {
            background: transparent;
            border: none;
            color: #0ecb81;
            width: 80px;
            text-align: center;
            text-transform: uppercase;
            font-weight: 700;
            font-size: 0.95rem;
        }

        #contextStock:focus {
            outline: none;
        }

        .chat-messages-area {
            flex: 1;
            overflow-y: auto;
            padding: 20px;
            display: flex;
            flex-direction: column;
            gap: 15px;
            background: #0b0e11;
        }

        .chat-msg {
            padding: 10px 14px;
            border-radius: 8px;
            font-size: 0.9rem;
            max-width: 80%;
            line-height: 1.5;
            word-wrap: break-word;
        }

        .chat-msg.ai {
            background: #1b2029;
            color: #e0e3eb;
            align-self: flex-start;
            border-left: 3px solid #3b82f6;
        }

        .chat-msg.user {
            background: rgba(59, 130, 246, 0.15);
            color: #fff;
            align-self: flex-end;
            border-right: 3px solid #0ecb81;
        }

        .typing {
            font-style: italic;
            color: #777;
            font-size: 0.8rem;
            margin-left: 20px;
            margin-bottom: 10px;
            display: none;
        }

        .chat-input-bar {
            padding: 20px;
            background: #131722;
            border-top: 1px solid #2b313f;
            display: flex;
            gap: 10px;
        }

        .chat-input {
            flex: 1;
            padding: 14px;
            background: #0b0e11;
            border: 1px solid #2b313f;
            color: #fff;
            border-radius: 6px;
            outline: none;
            font-size: 0.95rem;
        }

        .chat-input:focus {
            border-color: #3b82f6;
        }

        .btn-send {
            background: #3b82f6;
            color: #fff;
            border: none;
            padding: 0 25px;
            border-radius: 6px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s;
        }

        .btn-send:hover {
            background: #2563eb;
        }

        /* Scrollbar */
        ::-webkit-scrollbar {
            width: 6px;
        }

        ::-webkit-scrollbar-track {
            background: #0b0e11;
        }

        ::-webkit-scrollbar-thumb {
            background: #2b313f;
            border-radius: 3px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: #3b82f6;
        }
    </style>
</head>

<body>

    <!-- SIDEBAR -->
    <aside class="chat-sidebar">
        <div class="sidebar-header">WATCHLIST</div>
        <div class="quick-stocks">
            <div class="quick-item" onclick="setContext('NIFTY')"><span>NIFTY 50</span></div>
            <div class="quick-item" onclick="setContext('RELIANCE')"><span>RELIANCE</span></div>
            <div class="quick-item" onclick="setContext('HDFCBANK')"><span>HDFCBANK</span></div>
            <div class="quick-item" onclick="setContext('INFY')"><span>INFY</span></div>
            <div class="quick-item" onclick="setContext('TATAMOTORS')"><span>TATAMOTORS</span></div>
            <div class="quick-item" onclick="setContext('DLF')"><span>DLF</span></div>
            <div class="quick-item" onclick="setContext('ZOMATO')"><span>ZOMATO</span></div>
        </div>
    </aside>

    <!-- MAIN CHAT -->
    <div class="chat-container">
        <!-- Header -->
        <div class="chat-header-bar">
            <div style="font-weight:600; font-size:1.1rem; display:flex; align-items:center; gap:8px;">
                <span>🤖</span> AI GURU
            </div>
            <div class="stock-context-box">
                <span style="font-size:0.8rem; color:#888;">Talking about:</span>
                <input type="text" id="contextStock" value="NIFTY" readonly>
            </div>
        </div>

        <!-- Messages -->
        <div id="chatMessages" class="chat-messages-area">
            <div class="chat-msg ai">
                Namaskaram! Njan <b>AI Guru</b>. <br>
                Nammukku marketine kurichu samsarikkam. <br>
                <i>(Try: "Analysis for Reliance?", "Nifty status?")</i>
            </div>
        </div>

        <!-- Typing -->
        <div id="typingIndicator" class="typing">AI is thinking...</div>

        <!-- Input -->
        <div class="chat-input-bar">
            <input type="text" id="chatInput" class="chat-input" placeholder="Chodikku... (Eg: Buy cheyyamo?)"
                autocomplete="off" onkeypress="handleKey(event)">
            <button onclick="sendChat()" class="btn-send">SEND</button>
        </div>
    </div>

    <script>
        // Use URL Params to set initial context
        const urlParams = new URLSearchParams(window.location.search);
        const initialSymbol = urlParams.get('symbol');
        if (initialSymbol) {
            document.getElementById('contextStock').value = initialSymbol.toUpperCase();
        }

        function setContext(symbol) {
            document.getElementById('contextStock').value = symbol;
            addMsg(`<em>Context switched to ${symbol}...</em>`, 'ai');
        }

        function handleKey(e) { if (e.key === 'Enter') sendChat(); }

        async function sendChat() {
            const input = document.getElementById('chatInput');
            const msg = input.value.trim();
            if (!msg) return;

            addMsg(msg, 'user');
            input.value = '';

            const typing = document.getElementById('typingIndicator');
            typing.style.display = 'block';

            const stock = document.getElementById('contextStock').value.toUpperCase();

            // Artificial feel
            await new Promise(r => setTimeout(r, 500));

            try {
                // We send MINIMAL context. The Backend handles the heavy lifting.
                const context = {
                    symbol: stock,
                    signal: "ANALYZING" // Force backend to check fresh data
                };

                const res = await fetch('chat_engine.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ message: msg, context: context })
                });

                const text = await res.text();

                try {
                    const data = JSON.parse(text);
                    typing.style.display = 'none';
                    if (data.reply) {
                        addMsg(data.reply, 'ai');
                    } else {
                        addMsg("Sorry, I didn't understand. Try asking about a specific stock.", 'ai');
                    }
                } catch (e) {
                    typing.style.display = 'none';
                    console.error("JSON Error:", text);
                    // Polite Fallback
                    addMsg("System busy analyzing data. Please try again later.", 'ai');
                }

            } catch (err) {
                typing.style.display = 'none';
                console.error("Fetch Error:", err);
                addMsg("Connection weak. Reconnecting...", 'ai');
            }
        }

        function addMsg(text, type) {
            const box = document.getElementById('chatMessages');
            const div = document.createElement('div');
            div.className = `chat-msg ${type}`;
            div.innerHTML = text;
            box.appendChild(div);
            // Auto scroll
            box.scrollTop = box.scrollHeight;
        }

        // Focus on load
        document.getElementById('chatInput').focus();
    </script>
</body>

</html>