<?php
// debug_full_system.php
// Comprehensive "Z to Z" System Health Check
// Generated by AutoTradeAI Repair System

header('Content-Type: text/html; charset=utf-8');
ini_set('display_errors', 1);
error_reporting(E_ALL);

function pass($msg)
{
    echo "<div style='color:green; margin:5px 0;'>✅ PASS: $msg</div>";
}
function fail($msg)
{
    echo "<div style='color:red; margin:5px 0;'>❌ FAIL: $msg</div>";
}
function info($msg)
{
    echo "<div style='color:blue; margin:5px 0;'>ℹ️ INFO: $msg</div>";
}

echo "<h1>AutoTradeAI System Health Check (Z to Z)</h1>";
echo "<hr>";

// 1. FILE SYSTEM PERMISSIONS
echo "<h3>1. File System Permissions</h3>";
$files_to_check = [
    'users.json',
    'trade_history.json',
    'core/strategy_weights.json',
    'core/pattern_memory.json',
    'error_log',
    'core/news_cache.json'
];

foreach ($files_to_check as $f) {
    if (file_exists($f)) {
        if (is_writable($f)) {
            pass("$f is Writable");
        } else {
            fail("$f is NOT Writable (Permission Issue)");
        }
    } else {
        info("$f does not exist (Will be created if directory is writable)");
        if (is_writable(dirname($f))) {
            pass("Directory " . dirname($f) . " is Writable");
        } else {
            fail("Directory " . dirname($f) . " is NOT Writable");
        }
    }
}

// 2. DEPENDENCY CHECK
echo "<h3>2. Core Dependencies</h3>";
$deps = [
    'core/fetch_engine.php',
    'core/cache_engine.php',
    'core/api_guard.php',
    'trade_engine.php',
    'api.php'
];

foreach ($deps as $d) {
    if (file_exists($d)) {
        pass("$d Found");
    } else {
        fail("CRITICAL: $d Missing");
    }
}

// 3. FETCH ENGINE TEST (The Critical Fix)
echo "<h3>3. Data Fetch Engine Test (Anti-Block)</h3>";
require_once __DIR__ . '/core/fetch_engine.php';

$test_url = "https://query1.finance.yahoo.com/v8/finance/chart/RELIANCE.NS?interval=1d&range=1d";
$start = microtime(true);
$res = fetch_url_secure($test_url);
$end = microtime(true);

if ($res && strlen($res) > 500) {
    $json = json_decode($res, true);
    if (isset($json['chart']['result'][0]['meta']['symbol'])) {
        pass("Fetch SUCCESS: Received Data for " . $json['chart']['result'][0]['meta']['symbol']);
        info("Time Taken: " . round($end - $start, 3) . " seconds");
    } else {
        fail("Fetch Warning: Content received but JSON invalid");
    }
} else {
    fail("Fetch FAILED: Could not reach Yahoo Finance (Block or Network Issue)");
}

// 4. API ENDPOINT SIMULATION
echo "<h3>4. API Logic Test</h3>";
// Simulate GET request variables if needed, usually we just check file integrity here
if (file_exists('api/trade.php')) {
    pass("api/trade.php endpoint exists");
} else {
    fail("api/trade.php Missing");
}

echo "<hr>";
echo "<h3>Diagnosis Complete.</h3>";
?>