<?php
// fix_users_db.php
// Force users.json to be a pure indexed array to match V12 logic

$file = 'users.json';
if (file_exists($file)) {
    $users = json_decode(file_get_contents($file), true);
    if (!is_array($users))
        $users = [];

    // Convert keys to 0, 1, 2... (Array)
    $clean_users = array_values($users);

    // Save back
    file_put_contents($file, json_encode($clean_users, JSON_PRETTY_PRINT));
    echo "USERS.JSON Fixed: Converted to Indexed Array. Count: " . count($clean_users);
} else {
    echo "users.json not found.";
}
?>