<?php
// FORCE DELETE SCRIPT
// Upload this to public_html and run it: website.com/force_delete.php

echo "<h1>Force Delete Manager</h1>";
echo "<p>Attempts to delete stubborn files/folders using PHP permissions.</p>";
echo "<hr>";

// Define path to .trash (Usually one level up from public_html)
$base_dir = dirname(__DIR__); // /home/username
$trash_dir = $base_dir . '/.trash';

if (!is_dir($trash_dir)) {
    echo "<p style='color:red;'>Error: .trash folder not found at $trash_dir</p>";
    // Try current directory trash if exists (unlikely aka local)
    $trash_dir = __DIR__ . '/.trash';
    if (is_dir($trash_dir)) {
        echo "<p style='color:orange;'>Found .trash in current directory.</p>";
    }
} else {
    echo "<p style='color:green;'>Found .trash directory: $trash_dir</p>";
}

// Handle Deletion
if (isset($_POST['delete_item'])) {
    $item = $_POST['delete_item'];
    $full_path = $trash_dir . '/' . $item;

    // Security check to prevent deleting outside trash
    if (strpos(realpath($full_path), realpath($trash_dir)) !== 0) {
        echo "<p style='color:red;'>Security Warning: Cannot delete outside trash!</p>";
    } else {
        echo "<p>Attempting to delete: <strong>$item</strong></p>";
        $log = [];
        force_delete($full_path, $log);
        echo "<ul>";
        foreach ($log as $l)
            echo "<li>$l</li>";
        echo "</ul>";
    }
}

// List Items
$items = scandir($trash_dir);
echo "<h3>Contents of .trash:</h3>";
echo "<table border='1' cellpadding='5'><tr><th>Name</th><th>Type</th><th>Action</th></tr>";

foreach ($items as $item) {
    if ($item == '.' || $item == '..')
        continue;
    $type = is_dir($trash_dir . '/' . $item) ? 'Folder' : 'File';

    echo "<tr>
            <td>$item</td>
            <td>$type</td>
            <td>
                <form method='POST' onsubmit='return confirm(\"Are you sure you want to PERMANENTLY delete $item?\");'>
                    <input type='hidden' name='delete_item' value='$item'>
                    <input type='submit' value='Force Delete' style='background:red; color:white; border:none; padding:5px;'>
                </form>
            </td>
          </tr>";
}
echo "</table>";

// Helper Function
function force_delete($path, &$log)
{
    if (!file_exists($path)) {
        $log[] = "Skipped: $path (Not found)";
        return;
    }

    // Try to fix permissions first
    @chmod($path, 0777);

    if (is_file($path)) {
        if (@unlink($path)) {
            $log[] = "Deleted File: $path";
        } else {
            $log[] = "<span style='color:red'>Failed to delete file: $path (Permission Denied?)</span>";
        }
        return;
    }

    if (is_dir($path)) {
        $files = scandir($path);
        foreach ($files as $file) {
            if ($file != "." && $file != "..") {
                force_delete($path . "/" . $file, $log);
            }
        }
        if (@rmdir($path)) {
            $log[] = "Deleted Folder: $path";
        } else {
            $log[] = "<span style='color:red'>Failed to delete folder: $path</span>";
        }
    }
}
?>