<?php
require 'auth.php';
checkLogin();
$currUser = getUser($_SESSION['user_id']); // Fetch user details
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
    <meta http-equiv="Pragma" content="no-cache" />
    <meta http-equiv="Expires" content="0" />
    <title>AutoTrade AI | Pro Dashboard</title>
    <link rel="stylesheet" href="style.css?v=<?php echo time(); ?>_v7_unpin">
    <link rel="stylesheet" href="mobile.css?v=<?php echo time(); ?>_v7_unpin" media="(max-width: 768px)">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
</head>

<body>

    <!-- Sidebar -->
    <aside class="sidebar">
        <div class="logo-area" style="display:flex; justify-content:space-between; align-items:flex-start;">
            <div>
                AUTO<span>TRADE</span>.AI
                <div style="font-size: 0.6rem; color: #555; margin-top:0.2rem;">v12.0 (Hyper-Search)</div>
            </div>
            <div id="sidebarCloseBtn" style="display:none; cursor:pointer; color:#fff; font-size:1.5rem;">✕</div>
        </div>

        <div class="nav-menu">
            <div class="nav-item active">Dashboard</div>
            <div class="nav-item">Settings</div>
        </div>

        <div class="stock-list-header" id="watchlistHeader">NIFTY 50 WATCHLIST</div>
        <ul class="stock-list" id="stockListUl">
            <!-- List populated by JS -->
        </ul>

        <?php if (($currUser['plan'] ?? 'free') !== 'free' || ($currUser['role'] ?? 'user') === 'admin'): ?>
            <a href="paper/" target="_blank" class="nav-item"
                style="text-decoration:none; color:#eebb00; font-weight:bold; margin-top:20px; display:block;">📜 Paper
                Trade</a>
        <?php else: ?>
            <div class="nav-item" style="color:#555; margin-top:20px; cursor:not-allowed; opacity:0.5;"
                title="Upgrade to Premium">
                🔒 Paper Trade
            </div>
        <?php endif; ?>

        <a href="api.php?action=logout" class="logout" style="text-decoration:none;">Logout</a>
    </aside>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Bar -->
        <header class="top-bar">
            <!-- Mobile Menu Toggle -->
            <div id="mobileMenuBtn"
                style="display:none; cursor:pointer; font-size:1.5rem; margin-right:15px; color:#fff;">☰</div>

            <div class="search-bar" style="position:relative; display:flex; align-items:center; gap:10px;">
                <!-- Market Switcher -->
                <select id="marketSelect" onchange="switchMarket(this.value)"
                    style="background:#1e222d; color:#fff; border:1px solid #363c4e; padding:5px; border-radius:4px; cursor:pointer; font-weight:bold;">
                    <option value="IN">🇮🇳 NSE</option>
                    <option value="US">🇺🇸 US</option>
                </select>

                <input type="text" id="headerSearch" class="ticker-search" placeholder="Search Stock..."
                    autocomplete="off">
                <button class="btn-analyze" id="btnAnalyze">Analyze</button>
                <!-- Suggestions Dropdown -->
                <div id="searchSuggestions" class="suggestions-box" style="display:none; top:110%; width:220px;"></div>
            </div>
            <div class="user-profile">
                <div style="text-align:right;">
                    <div style="font-weight:600;"><?php echo htmlspecialchars($currUser['username']); ?></div>
                    <div style="font-size:0.75rem; color:var(--text-secondary); text-transform: capitalize;">
                        <?php echo htmlspecialchars($currUser['plan']); ?> Plan
                    </div>
                    <div style="font-size:0.65rem; color:#0ecb81; font-weight:bold; margin-top:2px;">
                        🧠 BRAIN LEVEL: 8
                    </div>
                </div>
            </div>
        </header>

        <!-- Grid -->
        <main class="dashboard-grid">

            <!-- Chart Side -->
            <section class="chart-section">
                <div class="price-header" style="justify-content: space-between; align-items: center;">
                    <div style="display:flex; align-items:center;">
                        <div class="current-price" id="displayPrice">₹0.00</div>
                        <div class="price-change" id="displayChange">0.00%</div>
                        <div class="data-source" id="dataSource"
                            style="font-size: 0.7rem; color: #7e879a; margin-left: 10px; align-self: center;">Source:
                            Loading...</div>
                    </div>

                    <!-- New Right Side Details -->
                    <div class="header-details"
                        style="text-align: right; font-size: 0.8rem; color: #7e879a; display: flex; gap: 15px;">
                        <div>
                            <span style="display:block; font-size:0.7rem; color:#555;">SYMBOL</span>
                            <span id="detailSymbol" style="color:#fff; font-weight:600;">--</span>
                        </div>
                        <div>
                            <span style="display:block; font-size:0.7rem; color:#555;">DAY HIGH</span>
                            <span id="detailHigh" style="color:#0ecb81;">--</span>
                        </div>
                        <div>
                            <span style="display:block; font-size:0.7rem; color:#555;">DAY LOW</span>
                            <span id="detailLow" style="color:#f6465d;">--</span>
                        </div>
                        <div>
                            <span style="display:block; font-size:0.7rem; color:#555;">VOLUME</span>
                            <span id="detailVol" style="color:#d1d4dc;">--</span>
                        </div>
                    </div>
                </div>

                <!-- Chart Controls (Timeframe) -->
                <div class="chart-controls" style="display: flex; gap: 5px; margin-bottom: 5px;">
                    <button class="time-btn active" onclick="changeTimeframe('1m', this)">1m</button>
                    <button class="time-btn" onclick="changeTimeframe('5m', this)">5m</button>
                    <button class="time-btn" onclick="changeTimeframe('15m', this)">15m</button>
                    <button class="time-btn" onclick="changeTimeframe('30m', this)">30m</button>
                    <button class="time-btn" onclick="changeTimeframe('1h', this)">1H</button>
                    <button class="time-btn" onclick="changeTimeframe('1d', this)">1D</button>
                    <button class="time-btn" onclick="changeTimeframe('1wk', this)">1W</button>
                    <button class="time-btn" onclick="changeTimeframe('1mo', this)">1M</button>
                    <button class="time-btn" onclick="changeTimeframe('1y', this)">1Y</button>
                </div>

                <div class="chart-wrapper" style="position: relative;">
                    <canvas id="candleChart"></canvas>
                    <!-- Zoom Controls -->
                    <div style="position: absolute; bottom: 50px; right: 80px; display: flex; gap: 5px; z-index: 100;">
                        <button id="btnZoomIn" title="Zoom In Time"
                            style="background: #2b313f; color: #fff; border: 1px solid #7e879a; width: 30px; height: 30px; cursor: pointer; border-radius: 4px;">+</button>
                        <button id="btnZoomOut" title="Zoom Out Time"
                            style="background: #2b313f; color: #fff; border: 1px solid #7e879a; width: 30px; height: 30px; cursor: pointer; border-radius: 4px;">-</button>
                        <div style="width:10px"></div>
                        <button onclick="vZoomIn()" title="Stretch Price"
                            style="background: #2b313f; color: #0ecb81; border: 1px solid #7e879a; width: 30px; height: 30px; cursor: pointer; border-radius: 4px;">↕+</button>
                        <button onclick="vZoomOut()" title="Compress Price"
                            style="background: #2b313f; color: #f6465d; border: 1px solid #7e879a; width: 30px; height: 30px; cursor: pointer; border-radius: 4px;">↕-</button>
                    </div>
                </div>

                <div class="footer-confidence">
                    <div>
                        <div id="aiFooterTitle" style="font-weight:700; font-size:0.9rem;">AI Confidence Score</div>
                        <div id="aiFooterReason" style="font-size:0.8rem; color:var(--text-secondary);">Analyzing Market
                            Structure...</div>
                    </div>
                </div>


                <!-- TICKER CONTAINER -->
                <div class="ticker-stack" style="margin-top:10px; display:flex; flex-direction:column; gap:5px;">

                    <!-- 1. INTRADAY -->
                    <div class="ticker-wrap-inline" id="ticker-intraday">
                        <div class="ticker-heading" style="color:#0ecb81; min-width:80px;">INTRADAY</div>
                        <div class="ticker-move">
                            <div class="ticker-item">Scanning...</div>
                        </div>
                    </div>

                    <!-- 2. SWING -->
                    <div class="ticker-wrap-inline" id="ticker-swing">
                        <div class="ticker-heading" style="color:#3b82f6; min-width:80px;">SWING</div>
                        <div class="ticker-move">
                            <div class="ticker-item">Scanning...</div>
                        </div>
                    </div>

                    <!-- 3. LONG TERM -->
                    <div class="ticker-wrap-inline" id="ticker-longterm">
                        <div class="ticker-heading" style="color:#eebb00; min-width:80px;">INVEST</div>
                        <div class="ticker-move">
                            <div class="ticker-item">Scanning...</div>
                        </div>
                    </div>

                </div>
                <!-- END TICKER CONTAINER -->



            </section>

            <!-- Analysis Side -->
            <aside class="analysis-panel">

                <div class="panel-card ai-card">
                    <div class="panel-title" style="display:flex; justify-content:space-between; align-items:center;">
                        AI PREDICTION ENGINE
                        <div style="display:flex; gap:5px; align-items:center;">
                            <select id="langSelect" onchange="window.switchLanguage()"
                                style="background:#0b0e11; color:#fff; border:1px solid #2b313f; border-radius:4px; padding:2px 5px; font-size:0.7rem; cursor:pointer;">
                                <option value="ml">Malayalam</option>
                                <option value="en">English</option>
                                <option value="hi">Hindi</option>
                            </select>
                            <span id="ai-regime"
                                style="font-size:0.6rem; padding:2px 6px; border-radius:4px; background:#2b313f; color:#7e879a;">Loading...</span>
                        </div>
                    </div>

                    <!-- TIME HORIZON TABS -->
                    <div class="ai-tabs">
                        <button class="ai-tab active" onclick="switchAI('intraday', this)">INTRADAY</button>
                        <button class="ai-tab" onclick="switchAI('swing', this)">SWING</button>
                        <button class="ai-tab" onclick="switchAI('longterm', this)">LONG-TERM</button>
                    </div>

                    <!-- AI CONTENT -->
                    <div id="ai-content-intraday" class="ai-content active">
                        <div class="signal-row">
                            <span class="signal-label">SIGNAL</span>
                            <span class="signal-val" id="ai-signal-intraday">WAIT</span>
                        </div>
                        <div class="signal-row">
                            <span class="signal-label">CONFIDENCE</span>
                            <div class="confidence-bar-bg">
                                <div class="confidence-bar-fill" id="ai-conf-intraday" style="width: 0%"></div>
                            </div>
                            <span id="ai-conf-val-intraday">0%</span>
                        </div>
                        <div class="malayalam-text" id="ai-desc-intraday">
                            Analyzing market momentum...
                        </div>
                    </div>

                    <div id="ai-content-swing" class="ai-content">
                        <div class="signal-row">
                            <span class="signal-label">TREND</span>
                            <span class="signal-val" id="ai-signal-swing">NEUTRAL</span>
                        </div>
                        <div class="signal-row">
                            <span class="signal-label">STRENGTH</span>
                            <div class="confidence-bar-bg">
                                <div class="confidence-bar-fill" id="ai-conf-swing" style="width: 0%"></div>
                            </div>
                            <span id="ai-conf-val-swing">0%</span>
                        </div>
                        <div class="malayalam-text" id="ai-desc-swing">
                            Checking daily trend structure...
                        </div>
                    </div>

                    <div id="ai-content-longterm" class="ai-content">
                        <div class="signal-row">
                            <span class="signal-label">OUTLOOK</span>
                            <span class="signal-val" id="ai-signal-longterm">HOLD</span>
                        </div>
                        <div class="signal-row">
                            <span class="signal-label">QUALITY</span>
                            <div class="confidence-bar-bg">
                                <div class="confidence-bar-fill" id="ai-conf-longterm" style="width: 0%"></div>
                            </div>
                            <span id="ai-conf-val-longterm">0%</span>
                        </div>
                        <div class="malayalam-text" id="ai-desc-longterm">
                            Reviewing fundamental strength...
                        </div>
                    </div>

                    <!-- SENTIMENT METER (Common) -->
                    <div class="sentiment-box" style="margin-top:15px; border-top:1px solid #2b313f; padding-top:10px;">
                        <div style="font-size:0.8rem; margin-bottom:5px; color:#7e879a;">NEWS SENTIMENT</div>
                        <div class="sentiment-meter">
                            <div class="meter-needle" id="sentiment-needle" style="left: 50%;"></div>
                        </div>
                    </div>
                </div>



                <!-- Detailed Analysis Breakdown -->
                <div class="panel-card" style="margin-top:5px;">
                    <div style="font-size:0.8rem; margin-bottom:8px; color:#7e879a; font-weight:600;">AI INSIGHTS</div>
                    <div id="ai-breakdown-box"
                        style="font-size:0.85rem; line-height:1.6; color:#a0aab9; background:#131722; padding:10px; border-radius:4px; border:1px solid #2b313f; min-height:80px;">
                        AI data analyzing...
                    </div>
                </div>

            </aside>

        </main>
    </div>

    <!-- Settings Modal -->
    <div id="settingsModal" class="modal"
        style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.7); z-index:2000; justify-content:center; align-items:center;">
        <div
            style="background:#1b2029; padding:25px; border-radius:8px; width:100%; max-width:400px; border:1px solid #2b313f;">
            <h3 style="margin-top:0; color:#fff; border-bottom:1px solid #2b313f; padding-bottom:10px;">Settings</h3>

            <!-- Plan Info -->
            <div
                style="margin-bottom:20px; padding:10px; background:rgba(59,130,246,0.1); border-radius:4px; border:1px solid rgba(59,130,246,0.3);">
                <div style="font-size:0.8rem; color:#aaa;">Current Plan</div>
                <div style="font-size:1.1rem; font-weight:700; color:#3b82f6;" id="userPlanDisplay">FREE</div>
                <button id="btnUpgrade"
                    style="margin-top:5px; width:100%; background:#3b82f6; border:none; color:#fff; padding:6px; font-weight:600; cursor:pointer;"
                    onclick="window.open('https://wa.me/919074023963?text=I%20want%20to%20upgrade%20to%20Premium', '_blank')">Upgrade
                    to Premium</button>
            </div>

            <!-- Position Sizing Settings -->
            <div style="margin-bottom:20px; border-bottom:1px solid #2b313f; padding-bottom:15px;">
                <h4 style="color:#eebb00; margin:0 0 10px 0; font-size:0.9rem;">AI Position Sizing</h4>

                <div style="margin-bottom:10px;">
                    <label style="display:block; font-size:0.8rem; color:#aaa; margin-bottom:5px;">Trading Capital (₹ /
                        $)</label>
                    <input type="number" id="userCapital" placeholder="e.g. 50000"
                        style="width:100%; padding:8px; background:#131722; border:1px solid #2b313f; color:#fff; border-radius:4px;">
                </div>

                <div style="margin-bottom:5px;">
                    <label style="display:block; font-size:0.8rem; color:#aaa; margin-bottom:5px;">Risk Per
                        Trade</label>
                    <select id="userRisk"
                        style="width:100%; padding:8px; background:#131722; border:1px solid #2b313f; color:#fff; border-radius:4px;">
                        <option value="0.01">1% (Conservative)</option>
                        <option value="0.02">2% (Standard)</option>
                        <option value="0.05">5% (Aggressive)</option>
                    </select>
                </div>
                <button onclick="savePositionSettings()"
                    style="width:100%; margin-top:10px; background:#0ecb81; border:none; color:#fff; padding:8px; font-weight:bold; cursor:pointer; border-radius:4px;">Save
                    Preferences</button>
            </div>

            <div style="margin-top:20px; border-top:1px solid #2b313f; padding-top:15px;">
                <h4 style="color:#fff; margin:0 0 10px 0; font-size:0.9rem;">Change Password</h4>
                <form id="changePassForm">
                    <input type="password" id="newPass" placeholder="New Password" required
                        style="width:100%; padding:8px; margin-bottom:10px; background:#131722; border:1px solid #2b313f; color:#fff; border-radius:4px;">
                    <button type="submit"
                        style="width:100%; background:#3b82f6; border:none; color:#fff; padding:8px; font-weight:bold; cursor:pointer; border-radius:4px;">Update
                        Password</button>
                </form>
            </div>
            <button onclick="document.getElementById('settingsModal').style.display='none'"
                style="margin-top:15px; width:100%; background:transparent; border:1px solid #2b313f; color:#aaa; padding:6px; cursor:pointer;">Close</button>
        </div>
    </div>

    <!-- SURE SHOT TOAST (Responsive) -->
    <div id="sureShotPopup" class="sure-shot-popup">
        <div class="ss-header">
            <div style="font-weight:bold; color:#fff;" id="ssTitle">AI ALERT 🎯</div>
            <div onclick="document.getElementById('sureShotPopup').style.display='none'"
                style="cursor:pointer; color:#777;">✕</div>
        </div>
        <div style="padding:15px;">
            <div style="display:flex; justify-content:space-between; margin-bottom:10px;">
                <span id="ssSymbol" style="font-size:1.1rem; font-weight:700; color:#fff;">RELIANCE</span>
                <span id="ssConf" class="ss-conf-badge">98%</span>
            </div>
            <div id="ssSignal" style="font-size:1.2rem; font-weight:800; color:#0ecb81; margin-bottom:5px;">STRONG BUY
            </div>
            <div id="ssReason" style="font-size:0.85rem; color:#aaa; line-height:1.4;">Breakout detected with high
                volume.</div>
        </div>
        <div class="ss-footer">
            <button onclick="document.getElementById('sureShotPopup').style.display='none'">Dismiss</button>
        </div>
    </div>

    <style>
        /* Base Desktop Styles (Facebook Message Style) */
        .sure-shot-popup {
            display: none;
            position: fixed;
            bottom: 20px;
            right: 20px;
            width: 320px;
            background: #1e222d;
            border: 1px solid #2b313f;
            border-radius: 8px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.5);
            z-index: 10000;
            animation: slideIn 0.3s ease-out;
            flex-direction: column;
        }

        .ss-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 15px;
            border-bottom: 1px solid #2b313f;
        }

        .ss-conf-badge {
            font-size: 0.9rem;
            font-weight: bold;
            background: rgba(14, 203, 129, 0.1);
            color: #0ecb81;
            padding: 2px 6px;
            border-radius: 4px;
        }

        .ss-footer {
            padding: 10px;
            border-top: 1px solid #2b313f;
            text-align: right;
        }

        .ss-footer button {
            background: transparent;
            border: 1px solid #444;
            color: #ccc;
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 0.8rem;
            cursor: pointer;
        }

        @keyframes slideIn {
            from {
                transform: translateX(100%);
            }

            to {
                transform: translateX(0);
            }
        }

        /* MOBILE OPTIMIZATION */
        @media (max-width: 768px) {
            .sure-shot-popup {
                right: 50%;
                /* Center horizontally */
                transform: translateX(50%);
                /* Center trick */
                bottom: 10px;
                /* Closer to bottom */
                width: 95%;
                /* Full width */
                animation: slideUp 0.3s ease-out;
                /* Slide Up instead of In */
            }

            @keyframes slideUp {
                from {
                    transform: translate(50%, 100%);
                }

                to {
                    transform: translate(50%, 0);
                }
            }
        }
    </style>

    <script>

        // Inject User Info from PHP to JS (Safe Mode)
        const USER_INFO = {
            id: <?php echo $_SESSION['user_id'] ?? 0; ?>,
            role: "<?php echo $_SESSION['role'] ?? 'user'; ?>",
            plan: "<?php echo $_SESSION['plan'] ?? 'free'; ?>"
        };
    </script>
    </script>
    <script src="stocks.js?v=V37"></script>
    <script src="app.js?v=V37_Global"></script>
</body>

</html>