<?php
// logout.php
// FIX #5: Logic to destroy headers correctly

require_once __DIR__ . '/core/session.php';

// 1. Unset array
$_SESSION = [];

// 2. Kill Cookie
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(
        session_name(),
        '',
        time() - 42000,
        $params["path"],
        $params["domain"],
        $params["secure"],
        $params["httponly"]
    );
}

// 3. Destroy Session
session_destroy();

// 4. Redirect (Absolute path is safest, but relative works if headers not sent)
header("Location: login.php");
exit;
?>