<?php
// setup.php
// Run this file in your browser: http://your-site.com/setup.php

echo "<h1>AutoTrade AI - Server Setup Check</h1>";

// 1. Check PHP Version
echo "<p><strong>PHP Version:</strong> " . phpversion() . "</p>";

// 2. Check Permissions
$store_file = 'store.json';
$is_writable = false;

if (file_exists($store_file)) {
    if (is_writable($store_file)) {
        echo "<p style='color:green'>[OK] store.json exists and is writable.</p>";
        $is_writable = true;
    } else {
        echo "<p style='color:red'>[ERROR] store.json exists but is NOT writable.</p>";
    }
} else {
    // Try to create it
    if (is_writable(__DIR__)) {
        echo "<p style='color:green'>[OK] Directory is writable. Creating store.json...</p>";
        file_put_contents($store_file, json_encode([
            "status" => "STOPPED",
            "balance" => 10000.00,
            "candles" => [],
            "last_close" => 7348.00,
            "trades" => [],
            "logs" => ["System Initialized"]
        ]));
        $is_writable = true;
    } else {
        echo "<p style='color:red'>[ERROR] Directory is NOT writable. Cannot create store.json.</p>";
    }
}

if ($is_writable) {
    echo "<h3>System is Ready!</h3>";
    echo "<p>You can now delete this setup.php file and go to <a href='index.php'>index.php</a>.</p>";
} else {
    echo "<h3>Action Required</h3>";
    echo "<p>Please set folder permissions (chmod 777 or 755) for the <code>public_html</code> folder or manually create <code>store.json</code> with write permissions.</p>";
}
?>