<?php
// setup_secure_users.php
// "Antigravity Style" - Secure Defaults

$users = [
    [
        "id" => 1,
        "username" => "admin",
        "password" => password_hash("123", PASSWORD_DEFAULT), // SECURE HASH
        "role" => "admin",
        "plan" => "premium",
        "status" => "active",
        "created_at" => date("Y-m-d H:i:s")
    ],
    [
        "id" => 2,
        "username" => "user",
        "password" => password_hash("123", PASSWORD_DEFAULT), // SECURE HASH
        "role" => "user",
        "plan" => "free",
        "status" => "active",
        "created_at" => date("Y-m-d H:i:s")
    ]
];

file_put_contents('users.json', json_encode($users, JSON_PRETTY_PRINT));
echo "SECURE USERS DB CREATED. Default Password '123' is now Hashed.";
?>