<?php
// system_repair_tool.php - Auto-Fix & Deep Clean
// Purpose: actively FIX issues (clear cache, reset permissions, show errors).

header('Content-Type: text/html; charset=utf-8');
ini_set('display_errors', 1);
error_reporting(E_ALL);

function action($msg)
{
    echo "<div style='color:green; margin:5px 0; font-family:monospace;'>⚡ ACTION: $msg</div>";
}
function ok($msg)
{
    echo "<div style='color:green; margin:5px 0;'>✅ OK: $msg</div>";
}
function warn($msg)
{
    echo "<div style='color:orange; margin:5px 0;'>⚠️ WARNING: $msg</div>";
}
function err($msg)
{
    echo "<div style='color:red; margin:5px 0; font-weight:bold;'>❌ ERROR: $msg</div>";
}

echo "<h1>🛠️ AutoTrade AI - System Repair Tool</h1>";
echo "<div style='background:#111; color:#0f0; padding:20px; font-family:monospace; border-radius:10px;'>";

// 1. CLEAR CACHE (often fixes "No Data")
echo "<h3>1. CLEARING CACHE (Fixes stuck data)</h3>";
$cache_dirs = ['data', 'data/charts'];
$deleted_count = 0;

foreach ($cache_dirs as $dir) {
    if (is_dir($dir)) {
        $files = glob("$dir/*.{json,txt}", GLOB_BRACE);
        foreach ($files as $file) {
            if (unlink($file))
                $deleted_count++;
        }
        action("Cleared $dir");
    } else {
        mkdir($dir, 0777, true);
        action("Created missing directory: $dir");
    }
}
ok("Deleted $deleted_count cached files. System will force-fetch new data now.");

// 2. FIX PERMISSIONS
echo "<h3>2. FIXING PERMISSIONS</h3>";
$critical_dirs = ['.', 'data', 'data/charts', 'core', 'ai'];
foreach ($critical_dirs as $d) {
    if (is_dir($d)) {
        if (@chmod($d, 0777))
            ok("Set 0777 on '$d'");
        else
            warn("Could not chmod '$d'. Check manually if write fails.");
    }
}

// 3. CHECK ERROR LOG (The "Full Debug" part)
echo "<h3>3. SERVER ERROR LOG (Last 20 Lines)</h3>";
$log_file = ini_get('error_log');
if ($log_file && file_exists($log_file)) {
    echo "<pre style='color:#fff; background:#333; padding:10px;'>";
    $lines = file($log_file);
    $lines = array_slice($lines, -20);
    foreach ($lines as $l)
        echo htmlspecialchars($l);
    echo "</pre>";
} else {
    warn("PHP Error Log not accessible or empty. ($log_file)");
    // Try local error_log
    if (file_exists('error_log')) {
        echo "<pre style='color:#fff; background:#333; padding:10px;'>";
        $lines = file('error_log');
        $lines = array_slice($lines, -20);
        foreach ($lines as $l)
            echo htmlspecialchars($l);
        echo "</pre>";
    }
}

// 4. API TEST WITH RESPONSE DUMP
echo "<h3>4. API RESPONSE DUMP (Testing 'RELIANCE.NS')</h3>";
require_once 'core/fetch_engine.php';
$test_url = "https://query1.finance.yahoo.com/v8/finance/chart/RELIANCE.NS?interval=1d&range=1d";
$res = fetch_url_secure($test_url);

if ($res) {
    $json = json_decode($res, true);
    if (isset($json['chart']['result'][0])) {
        ok("API is working perfectly. Data received.");
    } else {
        err("API connected but returned INVALID DATA. Dumping response:");
        echo "<textarea style='width:100%; height:100px; background:#222; color:#fff;'>" . htmlspecialchars(substr($res, 0, 500)) . "</textarea>";
    }
} else {
    err("API Connection FAILED entirely. Server might be blocking requests.");
}

echo "<hr><h2 style='color:#fff'>✨ REPAIR COMPLETE ✨</h2>";
echo "Now try opening your app. It should load fresh data.";
echo "</div>";
?>