<?php
// test_us_scan.php
$_GET['action'] = 'scan_market';
$_GET['market'] = 'US';
$_GET['limit'] = 5;

// Mock Session
session_start();
$_SESSION['role'] = 'admin';
$_SESSION['plan'] = 'premium'; // Avoid lock logic for test
session_write_close();

// Capture output
ob_start();
require 'api.php';
$output = ob_get_clean();

echo "<h3>API Output Check</h3>";
if (empty($output)) {
    echo "NO OUTPUT RECEIVED";
} else {
    echo "Output Length: " . strlen($output);
    echo "<pre>";
    // Try to decode JSON
    $json = json_decode($output, true);
    if ($json) {
        echo "VALID JSON RECEIVED\n";
        print_r($json);
    } else {
        echo "INVALID JSON:\n" . substr($output, 0, 1000);
    }
    echo "</pre>";
}
?>